<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:template match="Record">

		<!-- Render for 7.4 inch labels -->
		<image height="480" width="800" rotation="90" font-family="Verdana">

			<!-- Room -->
			<field height="108" width="780" x="10" y="20">
				<text align="center" font-size="40" font-weight="bold">
					<utils method="toUpperCase">
						<xsl:value-of select="room/@roomName"/>
					</utils>
				</text>

				<!-- Date -->
				<text align="center" font-size="35" font-weight="bold" padding-top="10">
					<xsl:value-of select="room/field[@key='date']/@value"/>
				</text>
			</field>

			<line thickness="2" x-from="0" x-to="800" y-from="130" y-to="130"/>

			<!-- Time1 -->
			<field height="50" width="780" x="20" y="150">
				<text align="left" font-weight="bold" font-size="40">
					<xsl:value-of select="room/field[@key='time1']/@value"/>
				</text>
			</field>

			<!-- Purpose1 -->
			<field height="50" width="780" x="20" y="200">
				<text align="left" font-size="40" condense="1, 0.8, 0.6, 0.5">
					<xsl:value-of select="room/field[@key='purpose1']/@value"/>
				</text>
			</field>

			<!-- Chair1 -->
			<field height="40" width="770" x="20" y="250">
				<text align="left" font-weight="bold" font-size="30">
					<xsl:value-of select="room/field[@key='chair1']/@value"/>
				</text>
			</field>

			<!-- Time2 -->
			<field height="35" width="780" x="20" y="320">
				<text align="left" font-size="28">
					<xsl:value-of select="room/field[@key='time2']/@value"/>
				</text>
			</field>

			<!-- Purpose2 -->
			<field height="35" width="780" x="20" y="355">
				<text align="left" font-size="28" condense="1, 0.8, 0.6, 0.5">
					<xsl:value-of select="room/field[@key='purpose2']/@value"/>
				</text>
			</field>


			<!-- Chair2 -->
			<field height="30" width="770" x="20" y="390">
				<text align="left" font-size="20">
					<xsl:value-of select="room/field[@key='chair2']/@value"/>
				</text>
			</field>

			<!-- LANCOM Logo -->
			<field align="right" height="60" width="780" x="10" y="410">
				<img src="../images/LANCOM_Logo_200.png" ></img>
			</field>


		</image>
	</xsl:template>
</xsl:stylesheet>