<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes"/>
<xsl:template match="/">
	<DiscoveryDoc xmlns="http://www.symbol.com/MSP/mspem" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
		<identity>
			<xsl:choose>
				<xsl:when test="/service-status/@name='Access Point'">
					<a n="deviceModel">iMAGOTAG_AP2010</a>
					<a n="deviceClass"><xsl:value-of select="/service-status/property[@key='device-type']" /></a>
					<a n="serial"><xsl:value-of select="/service-status/property[@key='serial']" /></a>
				</xsl:when>
				<xsl:otherwise>
					<a n="deviceModel">iMAGOTAG_ESL_Service</a>
					<a n="deviceClass"><xsl:value-of select="/service-status/@name"/></a>
				</xsl:otherwise>
			</xsl:choose>
			
			<a n="clientVersion"><xsl:value-of select="service-status/property[@key='version']"/></a>
			<a n="uuid"><xsl:value-of select="/service-status/property[@key='uuid']"/></a>
			<a n="deviceOS"><xsl:value-of select="/service-status/property[@key='os-type']"/></a>
		</identity>
		
		<inventory/>
		
		<settings/>
		
		<agent>
			<a n="feature">provision</a>
		</agent>
		
		<userAttribute>
			<a n="adapterbest.ipAddr"><xsl:value-of select="/service-status/property[@key='ip-address']"/></a>
			<a n="adapterbest.macAddr"><xsl:value-of select="/service-status/property[@key='mac-address']"/></a>
			<a n="adapterbest.name"><xsl:value-of select="/service-status/property[@key='adapter-name']"/></a>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.status</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='status']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.uptime</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='service-uptime']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.access-point-id</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='id']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.serialnumber</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='serial']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.auto-config</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='auto-config']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.version</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='version']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.build</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='build']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.firmware-version</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='firmware-version']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.revision</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='hardware-version']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.channel</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='channel']"/>
			</xsl:element>
			
			<xsl:element name="a">
				<xsl:attribute name="n">esl.labels</xsl:attribute>
				<xsl:value-of select="/service-status/property[@key='labels']"/>
			</xsl:element>
			
			<xsl:for-each select="/service-status/problem">
				<xsl:element name="a"><xsl:attribute name="n">esl.problem.<xsl:value-of select="@identifier"/></xsl:attribute>[<xsl:value-of select="@severity"/>] <xsl:value-of select="@message"/></xsl:element>
			</xsl:for-each>
		</userAttribute>
		
		<status/>
	</DiscoveryDoc>
</xsl:template>
</xsl:stylesheet>