<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	
<xsl:template match="Record">
<xsl:choose>



<!-- 
=================================
Render image for 2.0 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 200 and Label/DisplayHeight = 96">
	<image width="200" height="96">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!--<rect x="0" y="0" width="200" height="96" border="4" color="white"/>-->
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="0" width="200" height="96" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="2" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="120" width="264" height="32">
					<label font-family="Verdana" align="center">
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="0" y="82" width="200" height="8" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="32" height="27" width="200" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="62" height="15" width="200">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>

		<!-- imagotag -->
		<field x="5" y="4" height="14" width="70">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				imagotag
			</label>
		</field>

		<!-- Label type as text -->
		<field x="5" y="4" height="14" width="190">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>

	</image>
</xsl:when>



<!-- 
===========================
Render image for G-tag 6 HF
===========================
-->

<xsl:when test="Label/DisplayWidth = 256 and Label/DisplayHeight = 128">
	<image width="256" height="128">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<!--
				<line x-from="30" x-to="38" y-from="35" y-to="35" thickness="6" color="red"/>
				<line x-from="30" x-to="30" y-from="35" y-to="141" thickness="6" color="red"/>
				<line x-from="30" x-to="38" y-from="141" y-to="141" thickness="6" color="red"/>
				<line x-from="234" x-to="226" y-from="35" y-to="35" thickness="6" color="red"/>
				<line x-from="234" x-to="234" y-from="35" y-to="141" thickness="6" color="red"/>
				<line x-from="234" x-to="226" y-from="141" y-to="141" thickness="6" color="red"/>
				-->
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="20" width="256" height="60" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="2" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="80" width="256" height="18">
					<label font-family="Verdana" align="center">
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="5" y="110" height="15" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="54" y="112" width="196" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="45" height="27" width="256" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="75" height="15" width="256">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>
		
		<!-- imagotag -->
		<field x="5" y="4" height="14" width="70">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="5" y="4" height="14" width="246">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>

	</image>
</xsl:when>



<!-- 
====================================
Render image for Billa Refurbishment
====================================
-->

<xsl:when test="starts-with(Label/Id, 'B2')">
	<image width="264" height="176">

		<!-- Border to detect display breakage -->
		<rect x="0" y="0" width="264" height="176" border="8" color="white"/>
		
		<!-- Label ID as 1D barcode -->
		<field x="0" y="60" height="45" width="264" align="center">
			<barcode humanReadableEnabled="false" type="code128">
				<xsl:value-of select="Label/Id"/>
			</barcode>
		</field>
		
		<!-- Label ID as text -->
		<field x="0" y="110" height="15" width="264">
			<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
				<xsl:value-of select="Label/Id"/>
			</label>
		</field>
		
		<!-- imagotag -->
		<field x="8" y="8" height="14" width="70">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				Billa
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="124" y="8" height="50" width="132" align="right">
			<!--
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			-->
			<label font-family="Verdana" font-size="10" align="right">
				Bestpreis 2.7
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 2.7 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 264 and Label/DisplayHeight = 176">
	<image width="264" height="176">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				
				<!-- Border to detect display breakage -->
				<!-- <rect x="0" y="0" width="264" height="176" border="6" color="white"/> -->

				<!-- imagotag CI brackets -->
				<line x-from="30" x-to="38" y-from="35" y-to="35" thickness="6" color="red"/>
				<line x-from="30" x-to="30" y-from="35" y-to="141" thickness="6" color="red"/>
				<line x-from="30" x-to="38" y-from="141" y-to="141" thickness="6" color="red"/>
				<line x-from="234" x-to="226" y-from="35" y-to="35" thickness="6" color="red"/>
				<line x-from="234" x-to="234" y-from="35" y-to="141" thickness="6" color="red"/>
				<line x-from="234" x-to="226" y-from="141" y-to="141" thickness="6" color="red"/>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="42" width="264" height="80" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="3" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="120" width="264" height="32">
					<label font-family="Verdana" align="center">
						<span font-size="12" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="8" y="158" height="15" width="60">
					<label font-family="Verdana" font-size="10">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="54" y="160" width="200" height="9" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as 1D barcode -->
				<field x="0" y="60" height="45" width="264" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="110" height="15" width="264">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- imagotag -->
		<field x="8" y="8" height="14" width="70">
			<label font-family="Verdana" font-weight="bold" font-size="10">
				imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="124" y="8" height="50" width="132" align="right">
			<label font-family="Verdana" font-weight="bold" font-size="10" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 4.4 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 400 and Label/DisplayHeight = 300">
	<image width="400" height="300">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				<!--<rect x="0" y="0" width="400" height="300" border="8" color="white"/>-->

				<!-- imagotag CI brackets -->
				<line x-from="50" x-to="60" y-from="65" y-to="65" thickness="6" color="red"/>
				<line x-from="50" x-to="50" y-from="65" y-to="235" thickness="6" color="red"/>
				<line x-from="50" x-to="60" y-from="235" y-to="235" thickness="6" color="red"/>
				<line x-from="350" x-to="340" y-from="65" y-to="65" thickness="6" color="red"/>
				<line x-from="350" x-to="350" y-from="65" y-to="235" thickness="6" color="red"/>
				<line x-from="350" x-to="340" y-from="235" y-to="235" thickness="6" color="red"/>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="90" height="100" width="400" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="4">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="200" height="20" width="400">
					<label font-family="Verdana" font-weight="bold" font-size="16" align="center">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="10" y="276" height="15" width="100">
					<label font-family="Verdana" font-weight="bold" font-size="12">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="100" y="276" height="12" width="290" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
				
				<!-- Label ID as barcode -->
				<field x="0" y="120" height="45" width="400" align="center">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="170" height="20" width="400">
					<label font-family="Verdana" font-weight="bold" font-size="12" align="center">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- imagotag -->
		<field x="8" y="8" height="15" width="70">
			<label font-family="Verdana" font-weight="bold" font-size="12">
				imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="210" y="10" height="30" width="180">
			<label font-family="Verdana" font-weight="bold" font-size="12" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			<label font-family="Verdana" font-size="10" align="right">
				<xsl:value-of select="LabelInfo/Edition"/>
			</label>
		</field>
		
	</image>
</xsl:when>



<!-- 
=================================
Render image for 7.4 inch display
=================================
-->

<xsl:when test="Label/DisplayWidth = 480 and Label/DisplayHeight = 800">
	<xsl:choose>
		
		<!-- Special handling for prototype 6.6 versions -->
		<xsl:when test="LabelInfo/Type = 'Prototype 6.6'">
		
			<image width="800" height="480" colors="false" rotation="90">
				<!--<line x-from="0" x-to="800" y-from="240" y-to="240"/>-->
				
				<field width="800" height="240" x="0" y="240">
				
					<!-- Label ID as barcode -->
					<field x="0" y="90" width="800" height="45" align="center">
						<barcode humanReadableEnabled="false" type="code128">
							<xsl:value-of select="Label/Id"/>
						</barcode>
					</field>
					
					<!-- Label ID as text -->
					<field x="0" y="140" width="800" height="15">
						<label font-family="Verdana" font-weight="bold" align="center" font-size="12">
							<xsl:value-of select="Label/Id"/>
						</label>
					</field>
					
					<!-- imagotag -->
					<field x="15" y="15" height="25" width="200">
						<label font-family="Verdana" font-weight="bold" font-size="18">
							imagotag
						</label>
					</field>
					
					<!-- Label type as text -->
					<field x="605" y="15" width="180" height="50">
						<label font-family="Verdana" font-weight="bold" font-size="18" align="right">
							<xsl:choose>
								<xsl:when test="LabelInfo/Type">
									<xsl:value-of select="LabelInfo/Type"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Label/LabelType"/>
								</xsl:otherwise>
							</xsl:choose>
						</label>
						<xsl:if test="LabelInfo/Edition">
							<label font-family="Verdana" font-size="12" align="right" padding-top="2">
								<xsl:value-of select="LabelInfo/Edition"/>
							</label>
						</xsl:if>
					</field>
				</field>
			</image>
			
		</xsl:when>


		<!-- Special handling for LANCOM OEM versions -->
		<xsl:when test="LabelInfo/Type = 'LANCOM WDG-1 7.4'">
		
			<image width="800" height="480" colors="false" rotation="90">
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						<!--<rect x="0" y="0" width="480" height="800" border="8" color="white"/>-->

						<!-- Registration code as 2D barcode -->
						<field x="15" y="210" width="770" height="150" align="center" valign="top">
							<barcode humanReadableEnabled="false" type="qr" scale="5" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="15" y="130" width="770" height="75" align="center" valign="center">
							<label font-family="Tahoma" align="center">
								<span font-size="20">Registration code</span>
							</label>
							<label font-family="Tahoma" align="center">
								<span font-size="30" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="425" width="770" height="40" align="center" valign="bottom">
							<label font-family="Tahoma" font-size="22">
								<span font-size="22">Label ID </span><span font-size="22" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="15" y="355" width="770" height="20" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					
						<!-- Label ID as barcode -->
						<field x="15" y="240" width="770" height="50" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="180" width="770" height="60" align="center" valign="center">
							<label font-family="Tahoma" align="center" font-size="30">
								<span font-size="30">Label ID </span><span font-size="30" font-weight="bold"><xsl:value-of select="Label/Id"/></span>
							</label>
						</field>
		
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- LANCOM -->
				<field x="20" y="20" height="55" width="200">
					<img data="
iVBORw0KGgoAAAANSUhEUgAAAMgAAAAyCAYAAAAZUZThAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsVJREFUeNrsnQtqwzAMhlvTQwy2+5+sg92iIxuGNMQPOX5I9vfBYC1NIsf6JctJnPvr9bptfH58/f9z4Pvneb8NJmRbLftatf1sv5J9xtpdQkl7attQYk8P3wz1lbvBEOdIHbfFsSX7bGVDzWPUsi+2H2fdSXt0IqJfNwg6Oh2nWrXvc7Z1Kzu+Rls0tNlaQCixN3ebx0yRpPWEQo9jaC6wW0xaaO8bZy0qjJ5V61G8QlsBSvrPWW7oyKEBIlmjZjFVpPvsoeHajFWRaDl3I/qkpL+cdYW3dNocZ9Isks3+498sQoi1pWafOKsnpNcJsi6SmZH4QGlNq0ogWh0tVyQIZY66w1wGCTlorywiGbsjEl1Z5Op9fA8LKtfidP6E5tz+ou0mz5mL861tUh/JPR9Ouzg07tdiXeKj6awZThIAJL/lbt4OHQJ2GS4QyzcaIhJ7QUvaZ0tkEESCSEr76tHauUpnmrQ9/Va7SLTSNs11laQ/SgOZsxYFWoixls01somGjERWFGSQ1aORxmwC/UTutInjasNGZhELEVibbdqzFdO8Cju+1Y2F0msFrZ3XwlDu7pf9AQAyCAACAUAgAAgEYCx/10GYtwcIZBDEAcAQC6BMINx3A3DOpg0uFAIwxAJAIAAIBACBACjh7YGplq8c8Ptm1gxMZhAuGAIkMsgxwu9Fc5YBYt/tv0/tJ7RdSLjHx1rPstIqqwrCwBpE8lTZ2ap9OVmpZLvY70vtAMgSSGqJSv+95Lny/ee96FpHeTIHVB9iSQvr0PBG6pypKH8UVc5C0loWkYYJMkjqLUSpuiBn6DQC3tsBVTLIPtrmLvMfi/CjhkNX7QAI1iBns025tYWP1KXLxexrmyvOfdUOgGgN0volmvsa4jhdWzPqk0Ggeg1yljFyX38W2j41hKod5VN2AEgQPQ/CxTdYugYBgHd+BRgArs02c1KzQ3UAAAAASUVORK5CYII="/>
				</field>
				
				<!-- Label type as text -->
				<field x="600" y="20" width="180" height="30">
					<label font-family="Tahoma" font-weight="bold" font-size="18" align="right">
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<xsl:if test="LabelInfo/Edition">
						<label font-family="Tahoma" font-size="12" align="right">
							<xsl:value-of select="LabelInfo/Edition"/>
						</label>
					</xsl:if>
				</field>
				
			</image>
		</xsl:when>
		
		<xsl:otherwise>
			<image width="480" height="800">
				
				<!-- Set colors -->
				<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
					<xsl:attribute name="colors">true</xsl:attribute>
				</xsl:if>
		
				<!-- Set orientation -->
				<xsl:if test="LabelInfo/Orientation != ''">
					<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="LabelInfo/RegistrationCode">
						<!--<rect x="0" y="0" width="480" height="800" border="8" color="white"/>-->

						<!-- imagotag CI brackets -->
						<line x-from="60" x-to="75" y-from="200" y-to="200" thickness="6" color="red"/>
						<line x-from="60" x-to="60" y-from="200" y-to="600" thickness="6" color="red"/>
						<line x-from="60" x-to="75" y-from="600" y-to="600" thickness="6" color="red"/>
						<line x-from="420" x-to="405" y-from="200" y-to="200" thickness="6" color="red"/>
						<line x-from="420" x-to="420" y-from="200" y-to="600" thickness="6" color="red"/>
						<line x-from="420" x-to="405" y-from="600" y-to="600" thickness="6" color="red"/>
						
						<!-- Registration code as 2D barcode -->
						<field x="0" y="320" width="480" height="200" align="center" valign="center">
							<barcode humanReadableEnabled="false" type="qr" scale="5" errorCorrectionLevel="M">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
						<!-- Registration code as text -->
						<field x="0" y="485" width="480" height="32">
							<label font-family="Verdana" align="center">
								<span font-size="16" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
							</label>
						</field>
						
						<!-- Label ID as text -->
						<field x="15" y="770" height="25" width="200">
							<label font-family="Verdana" font-size="14" font-weight="bold">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
						
						<!-- Registration code as 1D barcode -->
						<field x="65" y="770" width="400" height="16" align="right">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="LabelInfo/RegistrationCode"/>
							</barcode>
						</field>
						
					</xsl:when>
					<xsl:otherwise>
					
						<!-- Label ID as barcode -->
						<field x="0" y="380" width="480" height="45" align="center">
							<barcode humanReadableEnabled="false" type="code128">
								<xsl:value-of select="Label/Id"/>
							</barcode>
						</field>
						
						<!-- Label ID as text -->
						<field x="0" y="430" width="480" height="15">
							<label font-family="Verdana" font-weight="bold" align="center" font-size="12">
								<xsl:value-of select="Label/Id"/>
							</label>
						</field>
		
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- imagotag -->
				<field x="15" y="15" height="25" width="200">
					<label font-family="Verdana" font-weight="bold" font-size="18">
						imagotag
					</label>
				</field>
				
				<!-- Label type as text -->
				<field x="285" y="15" width="180" height="30">
					<label font-family="Verdana" font-weight="bold" font-size="18" align="right">
						<xsl:choose>
							<xsl:when test="LabelInfo/Type">
								<xsl:value-of select="LabelInfo/Type"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Label/LabelType"/>
							</xsl:otherwise>
						</xsl:choose>
					</label>
					<xsl:if test="LabelInfo/Edition">
						<label font-family="Verdana" font-size="12" align="right">
							<xsl:value-of select="LabelInfo/Edition"/>
						</label>
					</xsl:if>
				</field>

			</image>
		</xsl:otherwise>
	</xsl:choose>
</xsl:when>



<!-- 
==================================
Render image for 10.2 inch display
==================================
-->

<xsl:when test="Label/DisplayWidth = 1024 and Label/DisplayHeight = 1280">
	<image width="1024" height="1280">

		<!-- Set colors -->
		<xsl:if test="Label/DisplayColors = 'BLACK_WHITE_RED'">
			<xsl:attribute name="colors">true</xsl:attribute>
		</xsl:if>

		<!-- Set orientation -->
		<xsl:if test="LabelInfo/Orientation != ''">
			<xsl:attribute name="rotation"><xsl:value-of select="LabelInfo/Orientation"/></xsl:attribute>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="LabelInfo/RegistrationCode">
				<!--<rect x="0" y="0" width="1024" height="1280" border="8" color="white"/>-->

				<!-- imagotag CI brackets -->
				<line x-from="200" x-to="220" y-from="440" y-to="440" thickness="16" color="red"/>
				<line x-from="200" x-to="200" y-from="440" y-to="840" thickness="16" color="red"/>
				<line x-from="200" x-to="220" y-from="840" y-to="840" thickness="16" color="red"/>
				<line x-from="824" x-to="804" y-from="440" y-to="440" thickness="16" color="red"/>
				<line x-from="824" x-to="824" y-from="440" y-to="840" thickness="16" color="red"/>
				<line x-from="824" x-to="804" y-from="840" y-to="840" thickness="16" color="red"/>
				
				<!-- Registration code as 2D barcode -->
				<field x="0" y="500" width="1024" height="250" align="center" valign="center">
					<barcode humanReadableEnabled="false" type="qr" scale="10" errorCorrectionLevel="M">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
				<!-- Registration code as text -->
				<field x="0" y="750" width="1024" height="44">
					<label font-family="Verdana" align="center">
						<span font-size="30" font-weight="bold"><xsl:value-of select="LabelInfo/RegistrationCode"/></span>
					</label>
				</field>
				
				<!-- Label ID as text -->
				<field x="15" y="1246" height="28" width="200">
					<label font-family="Verdana" font-size="20" font-weight="bold">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>
				
				<!-- Registration code as 1D barcode -->
				<field x="609" y="1246" width="400" height="20" align="right">
					<barcode humanReadableEnabled="false" type="code128">
						<xsl:value-of select="LabelInfo/RegistrationCode"/>
					</barcode>
				</field>
				
			</xsl:when>
			<xsl:otherwise>
			
				<!-- Label ID as barcode -->
				<field x="0" y="520" width="1024" height="110" align="center">
					<barcode humanReadableEnabled="false" type="code128" scale="3">
						<xsl:value-of select="Label/Id"/>
					</barcode>
				</field>
				
				<!-- Label ID as text -->
				<field x="0" y="640" width="1024" height="44">
					<label font-family="Verdana" font-weight="bold" align="center" font-size="32">
						<xsl:value-of select="Label/Id"/>
					</label>
				</field>

			</xsl:otherwise>
		</xsl:choose>
		
		<!-- imagotag -->
		<field x="15" y="15" height="44" width="200">
			<label font-family="Verdana" font-weight="bold" font-size="36">
				imagotag
			</label>
		</field>
		
		<!-- Label type as text -->
		<field x="609" y="15" width="400" height="80">
			<label font-family="Verdana" font-weight="bold" font-size="36" align="right">
				<xsl:choose>
					<xsl:when test="LabelInfo/Type">
						<xsl:value-of select="LabelInfo/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Label/LabelType"/>
					</xsl:otherwise>
				</xsl:choose>
			</label>
			<xsl:if test="LabelInfo/Edition">
				<label font-family="Verdana" font-size="12" align="right">
					<xsl:value-of select="LabelInfo/Edition"/>
				</label>
			</xsl:if>
		</field>
		
	</image>
</xsl:when>


</xsl:choose>
</xsl:template>

</xsl:stylesheet>
