import de.lcs.wep.calendar.CalendarReader;
import de.lcs.wep.rest.WePClient;
import de.lcs.wep.service.WePService;
import de.lcs.wep.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Properties;

/**
 * Created by sgreve on 31.03.2015.
 */
public class WePServiceTest {

    private static Logger logger = LogManager.getLogger(WePServiceTest.class);
    public static final String CALENDAR_PROPERTIES_FILE = "calendar.properties";
    public static final String CLIENT_PROPERTIES_FILE = "client.properties";
    public static final String SERVICE_PROPERTIES_FILE = "service.properties";

    public static void main(String[] args) {

        // create the calendar reader
        logger.debug("Reading calendar properties");
        Properties calProps = Utils.readProperties(CALENDAR_PROPERTIES_FILE);
        logger.info("Setting up calendar module");
        CalendarReader calReader = CalendarReader.fromProperties(calProps);

        // create the WeP client
        logger.debug("Reading client properties");
        Properties clientProps = Utils.readProperties(CLIENT_PROPERTIES_FILE);
        logger.info("Setting up client module");
        DummyClient client = new DummyClient(WePClient.fromProperties(clientProps));

        // create the service
        logger.debug("Reading service properties");
        Properties svcProps = Utils.readProperties(SERVICE_PROPERTIES_FILE);
        logger.info("Setting up WeP service");
        WePService service = WePService.fromProperties(svcProps);

        // assign calendar reader and wep client
        service.setCalendarReader(calReader);
        service.setClient(client);

        // launch the service
        logger.info("Starting WeP service");
        service.start();

    }
}
