import de.lcs.wep.calendar.Event;
import de.lcs.wep.rest.WePClient;
import de.lcs.wep.rest.response.LabelInfo;

import javax.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by sgreve on 31.03.2015.
 */
public class DummyClient extends WePClient {

    public DummyClient(WePClient parent) {
        super(parent.getHost(), parent.getPort());
    }


    /**
     * Overwriting this method simulates that we received a response from a WePServer telling
     * use there are some displays present.
     *
     * @param page number of pages
     * @param recordsPerPage number of records per page
     * @return a list of dummy labelinfos faking the presence of real ones
     * @throws JAXBException
     */
    @Override
    public List<LabelInfo> getLabelInfos(int page, int recordsPerPage) throws JAXBException {
        List<LabelInfo> labelInfos = new ArrayList<LabelInfo>();
        for (int i = 0; i < 5; i++) {
            LabelInfo li = new LabelInfo();
            li.setLabelId(String.valueOf(i));
            li.setType("Dummy");
            labelInfos.add(li);
        }
        labelInfos.get(0).setTags(Arrays.asList("ROOM_YELLOW"));
        labelInfos.get(1).setTags(Arrays.asList("ROOM_RED"));
        labelInfos.get(2).setTags(Arrays.asList("ROOM_GREY"));
        //labelInfos.get(3).setTags(Arrays.asList("ROOM_GREY"));
        labelInfos.get(4).setTags(Arrays.asList("ROOM_RED"));
        return labelInfos;
    }

    @Override
    public String postRoomSchedule(String labelID, String roomName, List<Event> events, boolean useAlias, String template) throws Exception {
        super.postRoomSchedule(labelID,roomName,events,useAlias,template);
        return "";
    }
}
