<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">

	<!-- display definition
	<xsl:variable name="labelType" select="Record/Label/LabelType" />
	<xsl:variable name="displayWidth" select="Record/Label/DisplayWidth" />
	<xsl:variable name="displayHeight" select="Record/Label/DisplayHeight" />
	-->

	<xsl:variable name="displayWidth" select="480"/>
	<xsl:variable name="displayHeight" select="800"/>

	<xsl:variable name="isVertical" select="true()"/>
	<xsl:variable name="headerIndent" select="8"/>
	<xsl:variable name="contentIndent" select="22"/>


	<xsl:template name="main_template" match="Record">
		<xsl:choose>
			<xsl:when test="$isVertical">
				<xsl:call-template name="image_template">
					<xsl:with-param name="imageWidth" select="$displayWidth"/>
					<xsl:with-param name="imageHeight" select="$displayHeight"/>
					<xsl:with-param name="rotation" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="image_template">
					<xsl:with-param name="imageWidth" select="$displayHeight"/>
					<xsl:with-param name="imageHeight" select="$displayWidth"/>
					<xsl:with-param name="rotation" select="0"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="image_template">
		<xsl:param name="imageWidth" as="xs:integer"/>
		<xsl:param name="imageHeight" as="xs:integer"/>
		<xsl:param name="rotation"/>

		<xsl:variable name="headerHeight" select="45"/>
		<xsl:variable name="footerHeight" select="30"/>

		<image width="{$imageWidth}" height="{$imageHeight}" rotation="{$rotation}">
			<!-- creating the title -->
			<xsl:call-template name="header_template">
				<xsl:with-param name="width" select="$imageWidth"/>
				<xsl:with-param name="height" select="$headerHeight"/>
			</xsl:call-template>

			<xsl:call-template name="content_template">
				<xsl:with-param name="width" select="$imageWidth"/>
				<xsl:with-param name="height" select="$imageHeight - $headerHeight - $footerHeight - 1"/>
				<xsl:with-param name="yOffset" select="$headerHeight"/>
			</xsl:call-template>

			<xsl:call-template name="footer_template">
				<xsl:with-param name="width" select="$imageWidth"/>
				<xsl:with-param name="height" select="$footerHeight"/>
				<xsl:with-param name="yOffset" select="$imageHeight - $footerHeight"/>
			</xsl:call-template>

		</image>
	</xsl:template>

	<xsl:template name="header_template">
		<xsl:param name="width" as="xs:integer"/>
		<xsl:param name="height" as="xs:integer"/>

		<xsl:variable name="padding" as="xs:integer" select="8"/>
		<xsl:variable name="font-size" select="25"/>

		<field x="0" width="{$width}" height="{$height}" background-color="black">
			<label font-size="{$font-size}"
				   padding-top="{$padding}"
				   padding-left="{$headerIndent}"
				   color="white">
				<xsl:value-of select="room/@name"/>
			</label>
		</field>
	</xsl:template>

	<xsl:template name="footer_template">
		<xsl:param name="width" as="xs:integer"/>
		<xsl:param name="height" as="xs:integer"/>
		<xsl:param name="yOffset" as="xs:integer"/>

		<xsl:variable name="padding" as="xs:integer" select="5"/>
		<xsl:variable name="font-size" select="12"/>

		<field x="0" y="{$yOffset}" width="{$width}" height="{$height}" background-color="black" align="right">
			<label font-size="{$font-size}"
				   padding-top="{$headerIndent}"
				   padding-left="{$headerIndent}"
				   color="white">
				Letze Aktualisierung am
				<xsl:value-of select="Task/CurrentDate"/> um
				<xsl:value-of select="substring(Task/CurrentTime,1,5)"/> Uhr
			</label>
		</field>
	</xsl:template>

	<xsl:template name="content_template">
		<xsl:param name="width" as="xs:integer"/>
		<xsl:param name="height" as="xs:integer"/>
		<xsl:param name="yOffset" as="xs:integer"/>

		<xsl:choose>
			<xsl:when test="$isVertical">
				<field x="0" width="{$width}" height="{round($height div 2)}">
					<xsl:call-template name="state_template">
						<xsl:with-param name="width" select="$width"/>
						<xsl:with-param name="height" select="round($height div 2)"/>
					</xsl:call-template>
				</field>
				<field x="0" width="{$width}" height="{round($height div 2)}">
					<xsl:call-template name="schedule_template" match="room">
						<xsl:with-param name="width" select="$width"/>
					</xsl:call-template>
				</field>
			</xsl:when>
			<xsl:otherwise>
				<field x="0" y="{$yOffset}" width="{round($width div 2)}" height="{$height - $yOffset}">
					<xsl:call-template name="state_template">
						<xsl:with-param name="width" select="round($width div 2)"/>
						<xsl:with-param name="height" select="$height - $yOffset"/>
					</xsl:call-template>
				</field>
				<field x="{round($width div 2 + 1)}" y="{$yOffset}" width="{round($width div 2 - 1)}"
					   height="{$height}">
					<xsl:call-template name="schedule_template" match="room">
						<xsl:with-param name="width" select="round($width div 2 - 1)"/>
					</xsl:call-template>
				</field>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="state_template">
		<xsl:param name="width" as="xs:integer"/>
		<xsl:param name="height" as="xs:integer"/>

		<xsl:variable name="stateSize" as="xs:integer" select="48"/>
		<xsl:variable name="stateSubSize" as="xs:integer" select="25"/>
		<xsl:variable name="qrSize" as="xs:integer" select="130"/>

		<field x="0" width="{$width}" height="{$height}" valign="CENTER">
			<field align="CENTER" height="{$stateSize}" width="{$width}" x="0">
				<label font-size="{$stateSize - 8}">
					<xsl:value-of select="room/@state"/>
				</label>
			</field>
			<field align="CENTER" height="{$stateSubSize}" width="{$width}" x="0">
				<label align="CENTER" font-size="{$stateSubSize - 5}">
					<xsl:value-of select="room/@substate"/>
				</label>
			</field>
			<field align="CENTER" height="{round($qrSize * 1.5)}" width="{$width}" x="0">
				<field align="CENTER" x="0" height="{$qrSize}" width="{$qrSize}">
					<!--<barcode autoscale="false" type="qr">Want to book this room for the next hour just by scanning the
						barcode? Please tell Robert Zores how cool this feature would be.

						Kind regards
						Snke
					</barcode>-->
				</field>
			</field>
		</field>
	</xsl:template>

	<xsl:template name="schedule_template" match="room">
		<xsl:param name="width" as="xs:integer"/>

		<xsl:variable name="header" select="30"/>
		<xsl:variable name="col1" select="round($width * 0.25)"/>
		<xsl:variable name="col2" select="$width - $col1 - 1"/>
		<xsl:variable name="fontSize" select="15"/>
		<xsl:variable name="padding" select="8"/>

		<xsl:for-each select="room/day">
			<xsl:call-template name="day_template">
				<xsl:with-param name="width" select="$width"/>
				<xsl:with-param name="col1" select="$col1"/>
				<xsl:with-param name="col2" select="$col2"/>
				<xsl:with-param name="padding" select="$padding"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="day_template" match="day">
		<xsl:param name="width" as="xs:integer"/>
		<xsl:param name="col1" as="xs:integer"/>
		<xsl:param name="col2" as="xs:integer"/>

		<xsl:variable name="padding" select="8"/>
		<xsl:variable name="rowHeight" select="30"/>

		<xsl:variable name="header" as="xs:integer" select="30"/>
		<xsl:variable name="thickness" select="2"/>

		<field x="0" width="{$width}" height="{$header}" valign="bottom">
			<text font-size="15" padding-left="{$contentIndent}" padding-bottom="{$padding}">
				<xsl:value-of select="@date"/>
			</text>
			<line x-from="0" y-from="{$header - $thickness}" x-to="{$width}" y-to="{$header - $thickness}"
				  thickness="{$thickness}"/>
		</field>

		<xsl:for-each select="event">
			<xsl:call-template name="event_template">
				<xsl:with-param name="width" select="$width"/>
				<xsl:with-param name="col1" select="$col1"/>
				<xsl:with-param name="col2" select="$col2"/>
				<xsl:with-param name="padding" select="$padding"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="event_template" match="event">
		<xsl:param name="width" as="xs:integer"/>
		<xsl:param name="padding" as="xs:integer"/>

		<xsl:variable name="row" as="xs:integer" select="30"/>
		<xsl:variable name="thickness" select="1"/>

		<xsl:variable name="fieldHeight" select="23"/>
		<xsl:variable name="fieldOffset" select="5"/>
		<xsl:variable name="textBig" select="20"/>
		<xsl:variable name="textSmall" select="12"/>
		<xsl:variable name="spacerHeight" select="10"/>

		<field x="0" width="{$width}" height="{$row}">
			<field y="0" width="22" x="22" height="{$row}">
				<text padding-top="3" font-size="{$textBig}">
					<xsl:value-of select="substring-before(start,':')"/>
				</text>
			</field>
			<field y="0" width="22" x="46" height="{$row}">
				<text padding-top="3" font-size="{$textSmall}">
					<xsl:value-of select="substring-after(start,':')"/>
				</text>
			</field>
			<field width="7" x="70" y="0" height="{$row}">
				<text padding-top="3" font-size="{$textBig}">-</text>
			</field>
			<field width="25" x="85" y="0" height="{$row}">
				<text padding-top="3" font-size="{$textBig}">
					<xsl:value-of select="substring-before(end,':')"/>
				</text>
			</field>
			<field width="22" x="110" y="0" height="{$row}">
				<text padding-top="3" font-size="{$textSmall}">
					<xsl:value-of select="substring-after(end,':')"/>
				</text>
			</field>
			<field width="311" x="150" y="0" height="{$row}">
				<text padding-top="3" font-size="{$textBig}">
					<xsl:value-of select="owner"/>
				</text>
			</field>
			<line x-from="0" y-from="{$row - $thickness}" x-to="{$width}" y-to="{$row - $thickness}"
				  thickness="{$thickness}"/>
		</field>
		<xsl:if test="position() = last()">
			<field x="0" width="{$width}" height="{$spacerHeight}"></field>
		</xsl:if>
	</xsl:template>


</xsl:stylesheet>