<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template match="Record">
        <image height="800" width="480">
            <rect height="64" width="480" x="0" y="0"/>
            <field height="64" width="480" x="0" y="0">
                <text color="white" font-size="30" padding-bottom="15" padding-left="15" padding-top="15"
                      shadow-color="white">
                    <xsl:value-of select="room/@name"/>
                </text>
            </field>
            <field align="CENTER" height="48" valign="TOP" width="480" x="0" y="122">
                <text font-size="40">
                    <xsl:value-of select="room/@state"/>
                </text>
            </field>
            <field align="CENTER" height="25" width="480" x="0" y="170">
                <text align="CENTER" font-size="20">
                    <xsl:value-of select="room/@substate"/>
                </text>
            </field>

            <field height="125" width="125" x="178" y="230">
                <barcode autoscale="true" type="qr">Want to book this room for the next hour? Please tell Robert Zores
                    how cool this feature would be.

                    Kind regards
                    S�nke
                </barcode>
            </field>

            <field height="23" width="134" x="12" y="485">
                <text font-size="18" font-weight="bold">Zeitraum</text>
            </field>
            <field height="23" width="311" x="150" y="485">
                <text font-size="18" font-weight="bold">Reserviert von</text>
            </field>
            <line thickness="3" x-from="0" x-to="480" y-from="510" y-to="510"/>

            <xsl:variable name="startPos" select="460"/>
            <xsl:variable name="rowHeight" select="50"/>
            <xsl:variable name="textOffset" select="15"/>

            <xsl:for-each select="room/day">
                <xsl:for-each select="./event">
                    <field height="23" width="22" x="22"
                           y="{$startPos + $textOffset + (count(preceding::owner) + 1)*$rowHeight}">
                        <text font-size="20">
                            <xsl:value-of select="substring-before(start,':')"/>
                        </text>
                    </field>
                    <field height="23" width="22" x="46"
                           y="{$startPos + $textOffset + (count(preceding::owner) + 1)*$rowHeight}">
                        <text font-size="13">
                            <xsl:value-of select="substring-after(start,':')"/>
                        </text>
                    </field>
                    <field height="23" width="7" x="70"
                           y="{$startPos + $textOffset + (count(preceding::owner) + 1)*$rowHeight}">
                        <text font-size="20">-</text>
                    </field>
                    <field height="23" width="25" x="85"
                           y="{$startPos + $textOffset + (count(preceding::owner) + 1)*$rowHeight}">
                        <text font-size="20">
                            <xsl:value-of select="substring-before(end,':')"/>
                        </text>
                    </field>
                    <field height="23" width="22" x="110"
                           y="{$startPos + $textOffset + (count(preceding::owner) + 1)*$rowHeight}">
                        <text font-size="13">
                            <xsl:value-of select="substring-after(end,':')"/>
                        </text>
                    </field>
                    <field height="23" width="311" x="150"
                           y="{$startPos + $textOffset + (count(preceding::owner) + 1)*$rowHeight}">
                        <text font-size="20">
                            <xsl:value-of select="owner"/>
                        </text>
                    </field>
                    <xsl:choose>
                        <xsl:when test="position()!=last()">
                            <line thickness="1" x-from="0" x-to="480"
                                  y-from="{$startPos  + $rowHeight + (count(preceding::owner) + 1)*$rowHeight}"
                                  y-to="{$startPos +  $rowHeight + (count(preceding::owner) + 1)*$rowHeight}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <line thickness="1" x-from="0" x-to="480"
                                  y-from="{$startPos -1 + $rowHeight + (count(preceding::owner) + 1)*$rowHeight}"
                                  y-to="{$startPos -1 +  $rowHeight + (count(preceding::owner) + 1)*$rowHeight}"/>
                            <line thickness="1" x-from="0" x-to="480"
                                  y-from="{$startPos +1  + $rowHeight + (count(preceding::owner) + 1)*$rowHeight}"
                                  y-to="{$startPos +1+  $rowHeight + (count(preceding::owner) + 1)*$rowHeight}"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:for-each>
        </image>
    </xsl:template>
</xsl:stylesheet>
