<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    <xsl:template name="title_template" match="room">
        <xsl:param name="width" as="xs:integer"/>
        <xsl:param name="height" as="xs:integer"/>
        <xsl:param name="title"/>
        <xsl:variable name="padding" as="xs:integer" select="8"/>
        <xsl:variable name="font-size" as="xs:integer" select="round(($height - 2 * $padding) * 0.88)"/>
        <field x="0" width="{$width}" height="{$height}" background-color="black">
            <label font-size="{$font-size}"
                   padding-top="{$padding}"
                   padding-left="{$padding}"
                   padding-right="{$padding}"
                   color="white">
                <xsl:value-of select="room/@name"/>
            </label>
        </field>
    </xsl:template>
</xsl:stylesheet>