<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:template match="Record">

        <xsl:variable name="rotation">0</xsl:variable>

        <xsl:variable name="bgcolor">
            <xsl:choose>
                <xsl:when test="article/field[@key='sale']/@value = '1'">black</xsl:when>
                <xsl:otherwise>white</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="fgcolor">
            <xsl:choose>
                <xsl:when test="article/field[@key='sale']/@value = '1'">white</xsl:when>
                <xsl:otherwise>black</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>

            <!-- Render for 7.4 inch labels -->
            <xsl:when test="Label/DisplayHeight = 800 and Label/DisplayWidth = 480">
                <image height="800" width="480" font-family="Verdana">
                    <xsl:attribute name="rotation">
                        <xsl:value-of select="$rotation"/>
                    </xsl:attribute>

                    <!-- Clear the background -->
                    <rect x="1" y="1" width="480" height="800">
                        <xsl:attribute name="color">
                            <xsl:value-of select="$bgcolor"/>
                        </xsl:attribute>
                    </rect>

                    <!-- Title -->
                    <field height="70" width="480" x="1" y="1" background-color="black">
                        <label font-size="35" font-weight="bold" condense="1, 0.8, 0.6, 0.5" padding-top="10"
                               padding-bottom="10" padding-left="10">
                            <xsl:attribute name="color">
                                <xsl:value-of select="$bgcolor"/>
                            </xsl:attribute>
                            <xsl:text>Raum: </xsl:text>
                            <xsl:value-of select="room/@roomname"/>
                        </label>
                    </field>

                    <!-- Room state -->
                    <field height="200" width="480" x="1" y="70">
                        <label font-size="40" font-weight="bold" condense="1, 0.8, 0.6, 0.5">
                            <xsl:attribute name="color">
                                <xsl:value-of select="$fgcolor"/>
                            </xsl:attribute>
                            <xsl:value-of select="room/field[@key='roomstate']/@value"/>
                        </label>
                    </field>

                    <field x="165" y="400" width="150" height="150">
                        <img data="iVBORw0KGgoAAAANSUhEUgAAAJYAAACWAQMAAAAGz+OhAAAABlBMVEX///8AAABVwtN+AAABIElEQVRIicWVQa7DIAxEXWXBkiNwE7hY1bTqxchNOAJLFiju2FS/v1nH1FKk8LKwccZjognhGFEvjVxZ6iqHSawQLTW11ALXGwpJFoz5WS9IJ8xzm8pQCy5uy8hlRk+nMulzdJlCp6/en8hUL2AtHDRky/5CNHQcFEMmtTzxZObuH9oMA0bhTgkzyAvPZIXLyhvmkrrf/Xv2z2YQj74GYXnktWdQ7qiFtJaNDRjy0pUS/mUh+Zeql0lsZVxTPQcf2YJ15I3iL93fcc7zmNaCGURsw9fs2QhtL2YfYsrns+FrsgdJPBvtnsSK+LjuwQW17B9vP5PJPoqSjkfMZGn46e53Z8aizIfoNP6/ry3T/YvbFl2IJuyza2UojvvXjP0oXlMdIbkbJiPvAAAAAElFTkSuQmCC&quot;">
                        </img>
                    </field>

                </image>
            </xsl:when>

        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>