<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:variable name="bgcolor">white</xsl:variable>
	<xsl:variable name="fgcolor">black</xsl:variable>
	
	<xsl:template match="Record">
		
		<!-- Render for 7.4 inch labels -->
		<image height="480" width="800" rotation="90" font-family="Verdana">
			<field height="108" width="780" x="10" y="20">
				<xsl:attribute name="background-color">white</xsl:attribute>
				<text align="center" font-size="40" font-weight="bold">
					<xsl:attribute name="color">black</xsl:attribute>
					<utils method="toUpperCase">
						<xsl:value-of select="room/@name"/>
					</utils>
				</text>								
				<xsl:for-each select="room/day[position() = 1]">
					<xsl:call-template name="date1">				
					</xsl:call-template>
				</xsl:for-each>				
			</field>
			
			<line thickness="2" x-from="0" x-to="800" y-from="130" y-to="130"/>

			<xsl:for-each select="room/day[position() = 1]">
				<xsl:call-template name="event1">				
				</xsl:call-template>
			</xsl:for-each>
			
			<xsl:for-each select="room/day[position() = 1]">
				<xsl:call-template name="event2">				
				</xsl:call-template>
			</xsl:for-each>

			<!-- LANCOM Logo -->
			<field align="right" height="60" width="780" x="10" y="410">
				<img src="../images/LANCOM_Logo_200.png" ></img>
			</field>

		</image>
	</xsl:template>

	<xsl:template name="date1">
		<text align="center" font-size="35" font-weight="bold" padding-top="10">			
			<xsl:value-of select="@date"/>
		</text>		
	</xsl:template>

	<xsl:template name="event1">
		<xsl:for-each select="event[position() = 1]">
			<xsl:call-template name="time1">				
			</xsl:call-template>
		</xsl:for-each>			
	</xsl:template>

	<xsl:template name="time1">
		<field height="50" width="780" x="20" y="150">			
			<text align="left" font-weight="bold" font-size="40">				
				<xsl:value-of select="start"/> - <xsl:value-of select="end"/>
			</text>
		</field>	
		<field height="50" width="780" x="20" y="200">
			<xsl:attribute name="background-color">white</xsl:attribute>
			<text align="left" font-size="40" condense="1, 0.8, 0.6, 0.5">
				<xsl:attribute name="color">black</xsl:attribute>
				<xsl:value-of select="subject"/>
			</text>
		</field>
		<field height="40" width="770" x="20" y="250">
			<xsl:attribute name="background-color">white</xsl:attribute>
			<text align="left" font-weight="bold" font-size="30">
				<xsl:attribute name="color">black</xsl:attribute>
				<xsl:value-of select="owner"/>
			</text>
		</field>		
	</xsl:template>

	<xsl:template name="event2">
		<xsl:for-each select="event[position() = 2]">
			<xsl:call-template name="time2">				
			</xsl:call-template>
		</xsl:for-each>			
	</xsl:template>

	<xsl:template name="time2">
		<field height="35" width="780" x="20" y="320">
			<text align="left" font-weight="bold" font-size="28">				
				<xsl:value-of select="start"/> - <xsl:value-of select="end"/>
			</text>
		</field>
		
		<field height="35" width="780" x="20" y="355">
			<xsl:attribute name="background-color">white</xsl:attribute>
			<text align="left" font-size="28" condense="1, 0.8, 0.6, 0.5">
				<xsl:attribute name="color">black</xsl:attribute>
				<xsl:value-of select="subject"/>
			</text>
		</field>
		
		<field height="30" width="770" x="20" y="390">
			<xsl:attribute name="background-color">white</xsl:attribute>
			<text align="left" font-size="20">
				<xsl:attribute name="color">black</xsl:attribute>
				<xsl:value-of select="owner"/>
			</text>
		</field>			
	</xsl:template>
	
</xsl:stylesheet>