<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:template match="Record">

		<xsl:variable name="bgcolor">
			<xsl:choose>
				<xsl:when test="room/field[@key='invert']/@value = '1'">black</xsl:when>
				<xsl:otherwise>white</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="fgcolor">
			<xsl:choose>
				<xsl:when test="room/field[@key='invert']/@value = '1'">white</xsl:when>
				<xsl:otherwise>black</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- Render for 7.4 inch labels -->
		<image height="480" width="800" rotation="90" font-family="Verdana">

			<!-- Room -->
			<field height="108" width="780" x="10" y="20">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="center" font-size="40" font-weight="bold">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<utils method="toUpperCase">
						<xsl:value-of select="room/@roomName"/>
					</utils>
				</text>

				<!-- Date -->
				<text align="center" font-size="35" font-weight="bold" padding-top="10">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='date']/@value"/>
				</text>
			</field>

			<line thickness="2" x-from="0" x-to="800" y-from="130" y-to="130"/>

			<!-- Time1 -->
			<field height="50" width="780" x="20" y="150">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="left" font-weight="bold" font-size="40">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='time1']/@value"/>
				</text>
			</field>

			<!-- Purpose1 -->
			<field height="50" width="780" x="20" y="200">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="left" font-size="40" condense="1, 0.8, 0.6, 0.5">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='purpose1']/@value"/>
				</text>
			</field>

			<!-- Chair1 -->
			<field height="40" width="770" x="20" y="250">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="left" font-weight="bold" font-size="30">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='chair1']/@value"/>
				</text>
			</field>

			<!-- Time2 -->
			<field height="35" width="780" x="20" y="320">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="left" font-size="28">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='time2']/@value"/>
				</text>
			</field>

			<!-- Purpose2 -->
			<field height="35" width="780" x="20" y="355">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="left" font-size="28" condense="1, 0.8, 0.6, 0.5">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='purpose2']/@value"/>
				</text>
			</field>


			<!-- Chair2 -->
			<field height="30" width="770" x="20" y="390">
				<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
				<text align="left" font-size="20">
					<xsl:attribute name="color"><xsl:value-of select="$fgcolor"/></xsl:attribute>
					<xsl:value-of select="room/field[@key='chair2']/@value"/>
				</text>
			</field>

			<!-- LANCOM Logo -->
			<field align="right" height="60" width="780" x="10" y="410">
				<img src="../images/LANCOM_Logo_200.png" ></img>
			</field>


		</image>
	</xsl:template>
</xsl:stylesheet>