<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="Record">
        <image height="176" width="264">
            <!-- Aktion -->
            <xsl:choose>
                <xsl:when test="article/field[@key='Sale']/@value='1'">
                    <rect color="black" height="126" width="264" x="0" y="0"/>
                    <field height="37" width="90" x="160" y="10">
                        <text color="white" font-family="Comic Sans MS" font-size="26" font-weight="bold">Aktion!</text>
                    </field>
                </xsl:when>
                <xsl:otherwise>
                    <line thickness="2" x-from="0" x-to="264" y-from="126" y-to="126"/>
                </xsl:otherwise>
            </xsl:choose>
            <!-- Name and Description -->
            <field height="40" width="150" x="9" y="10">
                <xsl:choose>
                    <xsl:when test="article/field[@key='Sale']/@value='1'">
                        <xsl:attribute name="width">150</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="width">240</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <text font-family="Tahoma" font-size="14">
                    <xsl:if test="article/field[@key='Sale']/@value='1'">
                        <xsl:attribute name="color">white</xsl:attribute>
                    </xsl:if>
                    <span font-weight="bold">
                        <utils method="toUpperCase">
                            <xsl:value-of select="article/field[@key='ProductDescription']/@value"/>
                        </utils>
                    </span>
                </text>
                <label font-family="Tahoma" font-size="16" padding-top="3">
                    <xsl:if test="article/field[@key='Sale']/@value='1'">
                        <xsl:attribute name="color">white</xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="article/field[@key='ProductName']/@value"/>
                </label>
            </field>
            <!-- Total amount -->
            <field height="20" width="50" x="10" y="100">
                <text align="left" font-family="Verdana" font-size="13">
                    <xsl:if test="article/field[@key='Sale']/@value='1'">
                        <xsl:attribute name="color">white</xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="article/field[@key='TotalAmount']/@value"/>
                </text>
            </field>
            <!-- Price -->
            <field height="83" width="190" x="60" y="50">
                <text align="right" condense="1,0.8,0.6,0.4" font-family="Impact" font-size="68,64,60,58,56">
                    <xsl:if test="article/field[@key='Sale']/@value='1'">
                        <xsl:attribute name="color">white</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="article/field[@key='MainPrice']/@value!=''">
                        <xsl:value-of select="floor(number(article/field[@key='MainPrice']/@value) div 100)"/>,<xsl:value-of
                            select="number(article/field[@key='MainPrice']/@value) mod 100"/>
                    </xsl:if>
                </text>
            </field>
            <!-- Dimension -->
            <field height="14" width="70" x="180" y="131">
                <text align="right" font-family="Verdana" font-size="11">
                    <xsl:if test="article/field[@key='UsedUnit']/@value!='' and article/field[@key='UsedUnit']/@value!='0'">
                        <span>per</span>
                        <xsl:if test="article/field[@key='UsedDimension']/@value='2'">
                            <span>100</span>
                        </xsl:if>
                    </xsl:if>
                    <span>
                        <xsl:choose>
                            <xsl:when test="article/field[@key='UsedUnit']/@value='1'">g</xsl:when>
                            <xsl:when test="article/field[@key='UsedUnit']/@value='2'">kg</xsl:when>
                            <xsl:when test="article/field[@key='UsedUnit']/@value='3'">l</xsl:when>
                            <xsl:when test="article/field[@key='UsedUnit']/@value='4'">ml</xsl:when>
                        </xsl:choose>
                    </span>
                </text>
            </field>
            <!-- Reference price -->
            <field height="24" width="70" x="180" y="146">
                <text align="right" font-family="Tahoma" font-size="20">
                    <xsl:if test="article/field[@key='ReferencePrice']/@value!=''">
                        <xsl:value-of select="floor(number(article/field[@key='ReferencePrice']/@value) div 100)"/>,<xsl:value-of
                            select="number(article/field[@key='ReferencePrice']/@value) mod 100"/>
                    </xsl:if>
                </text>
            </field>
            <!-- Label barcode -->
            <field align="center" height="20" width="160" x="10" y="136">
                <barcode autoscale="false" humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Label/Id"/>
                </barcode>
            </field>
            <!-- NAN, Location, Clearance, UpdateTime -->
            <field height="12" width="160" x="10" y="158">
                <text align="center" font-family="Tahoma" font-size="10">
                    <span>
                        <xsl:value-of select="number(article/field[@key='EAN']/@value)"/> /
                    </span>
                    <span>
                        <xsl:value-of select="article/field[@key='Location']/@value"/>
                    </span>
                    <xsl:if test="article/field[@key='Clearance']/@value='1'">
                        <span/>
                        <span font-weight="bold">R</span>
                    </xsl:if>
                    <span/>
                    <span>
                        <xsl:value-of select="article/field[@key='UpdateTime']/@value"/>
                    </span>
                </text>
            </field>
        </image>
    </xsl:template>
</xsl:stylesheet>
