<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="Record">
        <image height="300" width="400">
            <!-- Barcode Example -->
            <field height="100" width="100" x="10" y="10">
                <barcode autoscale="true" type="qr">
                    <xsl:value-of select="Barcodes/Qr"/>
                </barcode>
            </field>
            <field height="20" valign="bottom" width="100" x="10" y="110">
                <label align="center">QR Tag</label>
            </field>
            <field height="60" width="100" x="140" y="10">
                <barcode fontName="Tahoma" humanReadableEnabled="true" humanReadablePlacement="top" type="ean13">
                    <xsl:value-of select="Barcodes/Ean13"/>
                </barcode>
            </field>
            <field height="20" valign="bottom" width="100" x="140" y="110">
                <label align="center">EAN 13</label>
            </field>
            <field height="60" width="140" x="250" y="10">
                <barcode fontName="Tahoma" humanReadableEnabled="true" humanReadablePlacement="top" scale="2"
                         type="ean8">
                    <xsl:value-of select="Barcodes/Ean8"/>
                </barcode>
            </field>
            <field height="20" valign="bottom" width="100" x="270" y="110">
                <label align="center">EAN 8</label>
            </field>
            <field height="100" width="125" x="10" y="150">
                <barcode autoscale="true" type="code128">
                    <xsl:value-of select="Barcodes/Code128"/>
                </barcode>
            </field>
            <field height="20" valign="bottom" width="125" x="10" y="260">
                <label align="center">Code 128</label>
            </field>
            <field height="100" width="100" x="140" y="150">
                <barcode autoscale="true" type="datamatrix">
                    <xsl:value-of select="Barcodes/DataMatrix"/>
                </barcode>
            </field>
            <field height="20" valign="bottom" width="100" x="140" y="260">
                <label align="center">Datamatrix</label>
            </field>
            <field height="60" width="100" x="270" y="150">
                <barcode fontName="Times New Roman" humanReadableEnabled="true" humanReadablePlacement="bottom"
                         type="upc-a">
                    <xsl:value-of select="Barcodes/Upca"/>
                </barcode>
            </field>
            <field height="20" valign="bottom" width="100" x="270" y="260">
                <label align="center">UPC-A</label>
            </field>
        </image>
    </xsl:template>
</xsl:stylesheet>
