<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                version="2.0">

    <xsl:template match="Record">

        <xsl:variable name="price">
            <xsl:value-of select="article/field[@key='price']/@value"/>
        </xsl:variable>
        <xsl:variable name="name">
            <xsl:value-of select="article/field[@key='name']/@value"/>
        </xsl:variable>
        <xsl:variable name="description">
            <xsl:value-of select="article/field[@key='description']/@value"/>
        </xsl:variable>

        <image height="176" width="264" font-family="Verdana">

            <!-- Artikelbeschreibung -->
            <field height="80" width="225" x="5" y="7">
                <text font-size="16" font-weight="bold" condense="1.0, 0.9, 0.8, 0.7" line-spacing="-1"
                      padding-bottom="5">
                    <xsl:value-of select="$name"/>
                </text>
                <text font-size="14" font-weight="normal" condense="1.0, 0.9, 0.8, 0.7" line-spacing="-1"
                      padding-bottom="5">
                    <xsl:value-of select="$description"/>
                </text>
            </field>

            <!-- Preis -->
            <field height="100" width="140" x="0" y="75">
                <text align="right" font-family="Lucida Sans" font-size="80" font-weight="bold" condense="1.0">
                    <xsl:value-of select="substring-before($price, '.')"/>
                </text>
            </field>

            <!-- Preis (Punkt) -->
            <field height="80" width="20" x="135" y="95">
                <text align="center" font-family="Lucida Sans" font-size="60" font-weight="bold" condense="1.0">.</text>
            </field>

            <!-- Preis (Cent) -->
            <field height="90" width="80" x="135" y="79">
                <label align="left" font-family="Lucida Sans" font-size="52" font-weight="bold" condense="0.9">
                    <xsl:value-of select="substring-after($price, '.')"/>
                </label>
            </field>

            <!-- Artikelnummer als Barcode -->
            <field align="center" valign="center" rotation="270" height="25" width="150" x="230" y="17">
                <barcode scale="1" humanReadableEnabled="false" type="code128">1234567890ABCD</barcode>
            </field>

            <!-- Referenznummer als Text -->
            <field height="14" width="100" y="160" x="5">
                <label align="left" font-size="10" font-weight="normal">
                    <xsl:value-of select="article/@articleNumber"/>
                </label>
            </field>

        </image>
    </xsl:template>
</xsl:stylesheet>
