<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="Record">
        <image font-family="Arial" height="176" width="264">
            <line thickness="5" x-from="0" x-to="264" y-from="2" y-to="2"/>
            <field height="81" width="175" x="5" y="10">
                <label condense="1.0,0.8,0.6,0.5" font-size="34,33,32,30,28,26,24,22,20" font-weight="bold">
                    <xsl:value-of select="article/field[@key='name']/@value"/>
                </label>
                <text condense="1.0,0.8,0.6,0.5" font-size="20,19,18,16,12" padding-top="5">
                    <xsl:value-of select="article/field[@key='description']/@value"/>
                </text>
                <text condense="1.0,0.8,0.6,0.5" font-size="12" padding-top="3">
                    <ul float="true" type="disc">
                        <li>
                            <span font-weight="bold">Einheit:</span>
                            <xsl:value-of select="article/field[@key='unit']/@value"/> (€ <xsl:value-of
                                select="article/field[@key='pricePerUnit']/@value"/>) •
                        </li>
                    </ul>
                </text>
            </field>
            <field height="65" width="65" x="189" y="10">
                <barcode autoscale="true" type="qr">
                    <xsl:value-of select="article/@articleNumber"/>
                </barcode>
            </field>
            <line thickness="5" x-from="0" x-to="264" y-from="92" y-to="92"/>
            <field height="79" valign="center" width="264" x="0" y="95">
                <label align="center" condense="1.0,0.8,0.6,0.5"
                       font-size="70,68,66,64,62,60,58,56,54,52,50,48,46,44,42,40,38" font-style="italic"
                       font-weight="bold">€
                    <xsl:value-of select="article/field[@key='price']/@value"/>
                </label>
            </field>
            <line thickness="5" x-from="0" x-to="264" y-from="173" y-to="173"/>
        </image>
    </xsl:template>
</xsl:stylesheet>
