<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:template match="Record">
        <xsl:choose>
            <xsl:when test="Label/DisplayHeight = 176 and Label/DisplayWidth = 264">
                <image height="176" width="264">
                    <line thickness="2" x-from="0" x-to="264" y-from="126" y-to="126"/>

                    <!-- Name and Description -->
                    <field height="36" width="245" x="9" y="10">
                        <text font-family="Tahoma" font-size="14">
                            <span font-weight="bold">
                                <utils method="toUpperCase">
                                    <xsl:value-of select="article/field[@key='name']/@value"/>
                                </utils>
                            </span>
                            <br/>
                            <xsl:value-of select="article/field[@key='description']/@value"/>
                        </text>
                    </field>

                    <!-- Price -->
                    <field height="83" width="190" x="60" y="47">
                        <text align="right" font-family="Impact" font-size="68">
                            <xsl:value-of select="translate(article/field[@key='price']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Unit -->
                    <field height="14" width="70" x="180" y="131">
                        <text align="right" font-family="Verdana" font-size="11">
                            <xsl:value-of select="article/field[@key='unit']/@value"/>
                        </text>
                    </field>

                    <!-- Reference price -->
                    <field height="24" width="70" x="180" y="146">
                        <text align="right" font-family="Tahoma" font-size="20">
                            <xsl:value-of select="translate(article/field[@key='pricePerUnit']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Label barcode -->
                    <field align="center" height="20" width="140" x="10" y="136">
                        <barcode autoscale="false" humanReadableEnabled="false" type="ean13">
                            <xsl:value-of select="article/@articleNumber"/>
                        </barcode>
                    </field>

                    <!-- NAN, Location, Clearance, UpdateTime -->
                    <field height="12" width="140" x="10" y="158">
                        <text align="center" font-family="Tahoma" font-size="10">
                            <xsl:value-of select="article/@articleNumber"/>
                        </text>
                    </field>

                </image>
            </xsl:when>
            <xsl:when test="Label/DisplayHeight = 300 and Label/DisplayWidth = 400">
                <!-- Render image for 4.41 inch display -->
                <image height="300" width="400">

                    <line thickness="2" x-from="0" x-to="400" y-from="236" y-to="236"/>

                    <!-- Name and Description -->
                    <field height="90" width="382" x="9" y="10">
                        <text font-family="Tahoma" font-size="24">
                            <span font-weight="bold">
                                <utils method="toUpperCase">
                                    <xsl:value-of select="article/field[@key='name']/@value"/>
                                </utils>
                            </span>
                        </text>
                        <text font-family="Tahoma" font-size="18">
                            <br/>
                            <xsl:value-of select="article/field[@key='description']/@value"/>
                        </text>
                    </field>

                    <!-- Price -->
                    <field height="122" width="350" x="40" y="100">
                        <text align="right" font-family="Impact" font-size="100">
                            <xsl:value-of select="translate(article/field[@key='price']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Unit -->
                    <field height="14" width="70" x="320" y="248">
                        <text align="right" font-family="Verdana" font-size="11">
                            <xsl:value-of select="article/field[@key='unit']/@value"/>
                        </text>
                    </field>

                    <!-- Reference price -->
                    <field height="24" width="70" x="320" y="266">
                        <text align="right" font-family="Tahoma" font-size="20">
                            <xsl:value-of select="translate(article/field[@key='pricePerUnit']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Label barcode -->
                    <field align="center" height="20" width="140" x="10" y="260">
                        <barcode autoscale="false" humanReadableEnabled="false" type="ean13">
                            <xsl:value-of select="article/@articleNumber"/>
                        </barcode>
                    </field>

                    <!-- NAN, Location, Clearance, UpdateTime -->
                    <field height="12" width="140" x="10" y="282">
                        <text align="center" font-family="Tahoma" font-size="10">
                            <xsl:value-of select="article/@articleNumber"/>
                        </text>
                    </field>


                </image>
            </xsl:when>


            <xsl:when test="Label/DisplayHeight = 800 and Label/DisplayWidth = 480">
                <!-- Render image for 7.4 inch display -->
                <image height="800" width="480">

                    <line thickness="2" x-from="0" x-to="480" y-from="700" y-to="700"/>

                    <!-- Name and Description -->
                    <field height="400" width="460" x="10" y="10">
                        <text font-family="Tahoma" font-size="48">
                            <span font-weight="bold">
                                <utils method="toUpperCase">
                                    <xsl:value-of select="article/field[@key='name']/@value"/>
                                </utils>
                            </span>
                        </text>
                        <text font-family="Tahoma" font-size="28">
                            <br/>
                            <xsl:value-of select="article/field[@key='description']/@value"/>
                        </text>
                    </field>

                    <!-- Price -->
                    <field height="200" width="460" x="10" y="480">
                        <text align="right" font-family="Impact" font-size="120">
                            <xsl:value-of select="translate(article/field[@key='price']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Unit -->
                    <field height="32" width="100" x="370" y="728">
                        <text align="right" font-family="Verdana" font-size="26">
                            <xsl:value-of select="article/field[@key='unit']/@value"/>
                        </text>
                    </field>

                    <!-- Reference price -->
                    <field height="32" width="100" x="370" y="760">
                        <text align="right" font-family="Tahoma" font-size="26">
                            <xsl:value-of select="translate(article/field[@key='pricePerUnit']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Label barcode -->
                    <field align="center" height="20" width="140" x="10" y="758">
                        <barcode autoscale="false" humanReadableEnabled="false" type="ean13">
                            <xsl:value-of select="article/@articleNumber"/>
                        </barcode>
                    </field>

                    <!-- NAN, Location, Clearance, UpdateTime -->
                    <field height="12" width="140" x="10" y="780">
                        <text align="center" font-family="Tahoma" font-size="10">
                            <xsl:value-of select="article/@articleNumber"/>
                        </text>
                    </field>

                </image>
            </xsl:when>


        </xsl:choose>

    </xsl:template>

</xsl:stylesheet>
