<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                version="2.0">

    <xsl:template match="Record">

        <!-- Render image for 4.41 inch display -->
        <image height="300" width="400">

            <!-- Article Name -->
            <field height="130" width="380" x="10" y="10">
                <text font-family="Tahoma" font-size="30">
                    <xsl:value-of select="Article/Name"/>
                </text>
                <text font-family="Tahoma" font-size="22" padding-top="10">
                    <xsl:value-of select="Article/Description"/>
                </text>
            </field>

            <!-- Unit -->
            <field height="80" width="170" x="10" y="155">
                <text font-family="Tahoma" font-size="22" padding-top="10">
                    <xsl:value-of select="Article/Unit"/>
                </text>
            </field>

            <!-- Price -->
            <field height="171" width="170" x="135" y="129">
                <text align="right" font-family="Haettenschweiler" font-size="160">
                    <xsl:value-of select="substring-before(Article/Price,',')"/>.
                </text>
            </field>
            <field height="130" width="115" x="285" y="140">
                <text font-family="Haettenschweiler" font-size="115">
                    <xsl:value-of select="substring-after(Article/Price,',')"/>
                </text>
            </field>

            <!-- Article number as barcode -->
            <field align="center" height="30" width="120" x="10" y="240">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Article/@number"/>
                </barcode>
            </field>
            <field height="13" width="120" x="10" y="275">
                <text align="center" font-family="Tahoma" font-size="11">
                    <xsl:value-of select="Article/@number"/> /
                    <xsl:value-of select="Task/CurrentDate"/>
                </text>
            </field>
        </image>
    </xsl:template>

</xsl:stylesheet>
