<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- Last update: 2012-11-22 -->
    <xsl:template match="Record">
        <xsl:variable name="price">
            <xsl:value-of select="translate(Article/Price,'.','')"/>
        </xsl:variable>
        <xsl:variable name="maxProperties" select="8"/>
        <xsl:variable name="maxSpecifications" select="7"/>
        <!-- Render image for 7.4 inch display -->
        <image height="800" width="480">
            <!-- Product Category -->
            <field height="22" width="480" x="0" y="30">
                <text align="center" font-family="Verdana" font-size="18" text-decoration="underline">
                    <xsl:value-of select="Article/Category"/>
                </text>
            </field>
            <!-- Manufacturer -->
            <field height="36" width="480" x="0" y="65">
                <text align="center" font-family="Verdana" font-size="30" font-weight="bold">
                    <utils method="toUpperCase">
                        <xsl:value-of select="Article/Manufacturer"/>
                    </utils>
                </text>
            </field>
            <!-- Article Name -->
            <field height="60" width="450" x="15" y="110">
                <text align="center" font-family="Verdana" font-size="24">
                    <xsl:value-of select="Article/Name"/>
                </text>
            </field>
            <!-- List of article properties, specifications, packaging and accessories -->
            <field height="400" width="450" x="15" y="175">
                <text align="center" font-family="Tahoma" font-size="15" font-weight="bold">
                    <ul spacing="0" type="">
                        <xsl:for-each select="Article/Properties/Field">
                            <li>
                                <xsl:value-of select="."/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </text>
                <text align="left" font-family="Tahoma" font-size="18" font-weight="normal" padding-left="5"
                      padding-top="20">
                    <ul spacing="0" type="">
                        <xsl:for-each select="Article/Specification/Field">
                            <li>
                                <xsl:value-of select="."/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </text>
                <!--
                <text align="center" font-family="Tahoma" font-weight="normal" font-size="14" padding-top="12">
                    <xsl:value-of select="Article/Packaging/Item[1]"/>Test<br/>
                </text>
                <text align="center" font-family="Tahoma" font-weight="normal" font-size="14">
                    <xsl:value-of select="Article/Accessories/Item[1]"/><br/>
                </text>
                -->
            </field>
            <!-- Price -->
            <xsl:choose>
                <xsl:when test="number(substring-before($price, ',')) &lt; 100">
                    <xsl:choose>
                        <xsl:when test="substring-after($price,',') = '00'">
                            <field height="205" width="410" x="10" y="570">
                                <text align="right" font-family="Tahoma" font-size="170" font-style="italic"
                                      font-weight="bold">
                                    <xsl:value-of select="substring-before($price,',')"/>,-
                                </text>
                            </field>
                        </xsl:when>
                        <xsl:otherwise>
                            <field height="205" width="330" x="10" y="570">
                                <text align="right" font-family="Tahoma" font-size="170" font-style="italic"
                                      font-weight="bold">
                                    <xsl:value-of select="substring-before($price,',')"/>,
                                </text>
                            </field>
                            <field height="157" width="120" x="320" y="570">
                                <text font-family="Tahoma" font-size="85" font-style="italic" font-weight="bold">
                                    <xsl:value-of select="substring-after($price,',')"/>
                                </text>
                            </field>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="number(substring-before($price, ',')) &lt; 1000">
                    <xsl:choose>
                        <xsl:when test="substring-after($price,',') = '00'">
                            <field height="157" width="415" x="10" y="600">
                                <text align="right" font-family="Tahoma" font-size="130" font-style="italic"
                                      font-weight="bold">
                                    <xsl:value-of select="substring-before($price,',')"/>,-
                                </text>
                            </field>
                        </xsl:when>
                        <xsl:otherwise>
                            <field height="157" width="340" x="10" y="600">
                                <text align="right" font-family="Tahoma" font-size="130" font-style="italic"
                                      font-weight="bold">
                                    <xsl:value-of select="substring-before($price,',')"/>,
                                </text>
                            </field>
                            <field height="157" width="100" x="340" y="600">
                                <text font-family="Tahoma" font-size="70" font-style="italic" font-weight="bold">
                                    <xsl:value-of select="substring-after($price,',')"/>
                                </text>
                            </field>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="number(substring-before($price, ',')) &lt; 10000">
                    <xsl:choose>
                        <xsl:when test="substring-after($price,',') = '00'">
                            <field height="157" width="435" x="10" y="600">
                                <text align="right" font-family="Tahoma" font-size="110" font-style="italic"
                                      font-weight="bold">
                                    <xsl:value-of select="substring-before($price,',')"/>,-
                                </text>
                            </field>
                        </xsl:when>
                        <xsl:otherwise>
                            <field height="157" width="370" x="00" y="600">
                                <text align="right" font-family="Tahoma" font-size="110" font-style="italic"
                                      font-weight="bold">
                                    <xsl:value-of select="substring-before($price,',')"/>,
                                </text>
                            </field>
                            <field height="157" width="100" x="360" y="600">
                                <text font-family="Tahoma" font-size="55" font-style="italic" font-weight="bold">
                                    <xsl:value-of select="substring-after($price,',')"/>
                                </text>
                            </field>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
            </xsl:choose>
            <!-- Article number as barcode -->
            <field align="left" height="12" width="100" x="15" y="780">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Article/ArticleNumber"/>
                </barcode>
            </field>
            <field height="17" width="80" x="120" y="778">
                <text font-family="Tahoma" font-size="14">
                    <xsl:value-of select="Article/ArticleNumber"/>
                </text>
            </field>
            <!-- Label ID as barcode -->
            <field align="right" height="12" width="150" x="315" y="780">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Label/Id"/>
                </barcode>
            </field>
        </image>
    </xsl:template>
</xsl:stylesheet>
