<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                version="2.0">
    <!-- Last update: 2012-11-22 -->

    <xsl:template match="Record">
        <xsl:variable name="price">
            <xsl:value-of select="translate(Article/Price,'.','')"/>
        </xsl:variable>

        <!-- Number of maximum feature elements to show -->
        <xsl:variable name="maxElements" select="7"/>

        <!-- Number of nonempty properties -->
        <xsl:variable name="propertiesCount">
            <xsl:choose>
                <xsl:when test="Article/Properties/Field[1] != ''">
                    <xsl:value-of select="count(Article/Properties/Field)"/>
                </xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!-- Number of nonempty specifications -->
        <xsl:variable name="specificationsCount">
            <xsl:choose>
                <xsl:when test="Article/Specification/Field[1] != ''">
                    <xsl:value-of select="count(Article/Specification/Field)"/>
                </xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!-- Number of total nonempty features -->
        <xsl:variable name="totalCount" select="$propertiesCount + $specificationsCount"/>

        <!-- Render image for 4.41 inch display -->
        <image height="300" width="400">

            <!-- Product Category -->
            <field height="20" width="400" x="0" y="8">
                <text align="center" font-family="Tahoma" font-size="14" font-weight="bold" text-decoration="underline">
                    <xsl:value-of select="Article/Category"/>
                </text>
            </field>

            <!-- Manufacturer -->
            <field height="27" width="400" x="0" y="28">
                <text align="center" font-family="Verdana" font-size="22" font-weight="bold">
                    <utils method="toUpperCase">
                        <xsl:value-of select="Article/Manufacturer"/>
                    </utils>
                </text>
            </field>

            <!-- Article Name -->
            <field height="48" width="390" x="5" y="54">
                <text align="center" font-family="Verdana" font-size="18">
                    <xsl:value-of select="Article/Name"/>
                </text>
            </field>

            <!-- List of article properties and specifications -->
            <field height="80" width="390" x="5" y="103">
                <text align="center" font-family="Tahoma" font-size="15,13">
                    <ul float="true" type="disc">


                        <!-- List of properties -->
                        <xsl:if test="Article/Properties/Field[1] != ''">
                            <xsl:for-each select="Article/Properties/Field">

                                <li>
                                    <xsl:value-of select="."/>
                                </li>

                            </xsl:for-each>
                        </xsl:if>


                        <!-- List of specifications -->
                        <xsl:if test="Article/Specification/Field[1] != ''">
                            <xsl:for-each select="Article/Specification/Field">

                                <li>
                                    <xsl:value-of select="."/>
                                </li>

                            </xsl:for-each>
                        </xsl:if>
                    </ul>
                </text>
            </field>

            <!-- Price -->
            <xsl:choose>
                <xsl:when test="substring-after($price,',') = '00'">
                    <field height="87" width="390" x="5" y="185">
                        <text align="right" font-family="Tahoma" font-size="80" font-style="italic" font-weight="bold">
                            <xsl:value-of select="substring-before($price,',')"/>,-
                        </text>
                    </field>
                </xsl:when>
                <xsl:otherwise>
                    <field height="97" width="335" x="5" y="185">
                        <text align="right" font-family="Tahoma" font-size="80" font-style="italic" font-weight="bold">
                            <xsl:value-of select="substring-before($price,',')"/>,
                        </text>
                    </field>
                    <field align="left" height="87" width="65" x="330" y="190">
                        <text font-family="Tahoma" font-size="40" font-style="italic" font-weight="bold">
                            <xsl:value-of select="substring-after($price,',')"/>
                        </text>
                    </field>
                </xsl:otherwise>
            </xsl:choose>

            <!-- Article number as barcode -->
            <field height="10" width="98" x="6" y="287">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Article/ArticleNumber"/>
                </barcode>
            </field>
            <field height="14" width="60" x="110" y="286">
                <text font-family="Tahoma" font-size="12">
                    <xsl:value-of select="Article/ArticleNumber"/>
                </text>
            </field>

            <!-- Label ID as barcode -->
            <field align="right" height="10" width="180" x="212" y="287">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Label/Id"/>
                </barcode>
            </field>
        </image>
    </xsl:template>

</xsl:stylesheet>
