<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                version="2.0">
    <!-- Last update: 2012-11-22 -->

    <xsl:template match="Record">
        <xsl:variable name="price">
            <xsl:value-of select="translate(Article/Price,'.','')"/>
        </xsl:variable>

        <!-- Render image for 2.7 inch display -->
        <image height="176" width="264">

            <!-- Product Category -->
            <field height="20" width="256" x="8" y="8">
                <text font-family="Verdana" font-size="10" text-decoration="underline">
                    <xsl:value-of select="Article/Category"/>
                </text>
            </field>

            <!-- Manufacturer -->
            <field height="19" width="256" x="8" y="28">
                <text font-family="Verdana" font-size="16" font-weight="bold">
                    <utils method="toUpperCase">
                        <xsl:value-of select="Article/Manufacturer"/>
                    </utils>
                </text>
            </field>

            <!-- Article Name -->
            <field height="19" width="256" x="8" y="48">
                <text font-family="Verdana" font-size="16">
                    <xsl:value-of select="Article/Name"/>
                </text>
            </field>

            <!-- Price -->
            <xsl:choose>
                <xsl:when test="substring-after($price,',') = '00'">
                    <field height="78" width="250" x="0" y="83">
                        <text align="right" font-family="Tahoma" font-size="65" font-style="italic" font-weight="bold">
                            <xsl:value-of select="substring-before($price,',')"/>,-
                        </text>
                    </field>
                </xsl:when>
                <xsl:otherwise>
                    <field height="78" width="210" x="0" y="83">
                        <text align="right" font-family="Tahoma" font-size="65" font-style="italic" font-weight="bold">
                            <xsl:value-of select="substring-before($price,',')"/>,
                        </text>
                    </field>
                    <field height="78" width="64" x="200" y="83">
                        <text align="left" font-family="Tahoma" font-size="35" font-style="italic" font-weight="bold">
                            <xsl:value-of select="substring-after($price,',')"/>
                        </text>
                    </field>
                </xsl:otherwise>
            </xsl:choose>

            <!-- Article number as barcode -->
            <field height="8" width="105" x="4" y="165">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Article/ArticleNumber"/>
                </barcode>
            </field>
            <field height="13" width="60" x="3" y="153">
                <text font-family="Tahoma" font-size="11">
                    <xsl:value-of select="Article/ArticleNumber"/>
                </text>
            </field>

            <!-- Label ID as barcode -->
            <field align="right" height="8" width="146" x="114" y="165">
                <barcode humanReadableEnabled="false" type="code128">
                    <xsl:value-of select="Label/Id"/>
                </barcode>
            </field>

        </image>
    </xsl:template>

</xsl:stylesheet>
