<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:template match="Record">
        <xsl:choose>
            <xsl:when test="Label/DisplayHeight = 176 and Label/DisplayWidth = 264">
                <image height="176" width="264">

                    <rect color="black" height="126" width="264" x="0" y="0"/>
                    <field height="40" width="90" x="160" y="8">
                        <text color="white" font-family="Comic Sans MS" font-size="26" font-weight="bold">Aktion!</text>
                    </field>

                    <!-- Name and Description -->
                    <field height="51" width="148" x="9" y="8">
                        <text color="white" font-family="Tahoma" font-size="14" condense="1,0.8,0.6">
                            <span font-weight="bold">
                                <utils method="toUpperCase">
                                    <xsl:value-of select="article/field[@key='name']/@value"/>
                                </utils>
                            </span>
                            <br/>
                            <xsl:value-of select="article/field[@key='description']/@value"/>
                        </text>
                    </field>

                    <!-- Price -->
                    <field height="83" width="220" x="30" y="49">
                        <text color="white" align="right" font-family="Impact" font-size="68">
                            <xsl:if test="article/field[@key='sale']/@value = '1' or article/field[@key='sale']/@value = 'true'">
                                <xsl:attribute name="color">white</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="translate(article/field[@key='price']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Unit -->
                    <field height="14" width="70" x="180" y="131">
                        <text align="right" font-family="Verdana" font-size="11">
                            <xsl:value-of select="article/field[@key='unit']/@value"/>
                        </text>
                    </field>

                    <!-- Reference price -->
                    <field height="24" width="70" x="180" y="146">
                        <text align="right" font-family="Tahoma" font-size="20">
                            <xsl:value-of select="translate(article/field[@key='pricePerUnit']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Label barcode -->
                    <field align="center" height="20" width="140" x="10" y="136">
                        <barcode autoscale="false" humanReadableEnabled="false" type="ean13">
                            <xsl:value-of select="article/@articleNumber"/>
                        </barcode>
                    </field>

                    <!-- NAN, Location, Clearance, UpdateTime -->
                    <field height="12" width="140" x="10" y="158">
                        <text align="center" font-family="Tahoma" font-size="10">
                            <xsl:value-of select="article/@articleNumber"/>
                        </text>
                    </field>

                </image>
            </xsl:when>
            <xsl:when test="Label/DisplayHeight = 300 and Label/DisplayWidth = 400">
                <!-- Render image for 4.41 inch display -->
                <image height="300" width="400">


                    <rect color="black" height="236" width="400" x="0" y="0"/>
                    <field height="39" width="90" x="300" y="10">
                        <text color="white" font-family="Comic Sans MS" font-size="26" font-weight="bold">Aktion!</text>
                    </field>


                    <!-- Name and Description -->
                    <field height="100" width="290" x="9" y="10">
                        <text color="white" font-family="Tahoma" font-size="24,22" condense="1,0.8,0.6,0.4">
                            <span font-weight="bold">
                                <utils method="toUpperCase">
                                    <xsl:value-of select="article/field[@key='name']/@value"/>
                                </utils>
                            </span>
                        </text>
                        <text color="white" font-family="Tahoma" font-size="18">
                            <br/>
                            <xsl:value-of select="article/field[@key='description']/@value"/>
                        </text>
                    </field>

                    <!-- Price -->
                    <field height="124" width="350" x="40" y="110">
                        <text color="white" align="right" font-family="Impact" font-size="100">
                            <xsl:if test="article/field[@key='sale']/@value = '1' or article/field[@key='sale']/@value = 'true'">
                                <xsl:attribute name="color">white</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="translate(article/field[@key='price']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Unit -->
                    <field height="14" width="70" x="320" y="248">
                        <text align="right" font-family="Verdana" font-size="11">
                            <xsl:value-of select="article/field[@key='unit']/@value"/>
                        </text>
                    </field>

                    <!-- Reference price -->
                    <field height="24" width="70" x="320" y="266">
                        <text align="right" font-family="Tahoma" font-size="20">
                            <xsl:value-of select="translate(article/field[@key='pricePerUnit']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Label barcode -->
                    <field align="center" height="20" width="140" x="10" y="260">
                        <barcode autoscale="false" humanReadableEnabled="false" type="ean13">
                            <xsl:value-of select="article/@articleNumber"/>
                        </barcode>
                    </field>

                    <!-- NAN, Location, Clearance, UpdateTime -->
                    <field height="12" width="140" x="10" y="282">
                        <text align="center" font-family="Tahoma" font-size="10">
                            <xsl:value-of select="article/@articleNumber"/>
                        </text>
                    </field>


                </image>
            </xsl:when>


            <xsl:when test="Label/DisplayHeight = 800 and Label/DisplayWidth = 480">
                <!-- Render image for 7.4 inch display -->
                <image height="800" width="480">

                    <rect color="black" height="700" width="480" x="0" y="0"/>
                    <field height="56" width="150" x="320" y="200">
                        <text color="white" font-family="Comic Sans MS" font-size="40" font-weight="bold">Aktion!</text>
                    </field>


                    <!-- Name and Description -->
                    <field height="190" width="460" x="10" y="10">
                        <text color="white" font-family="Tahoma" font-size="48,46,44,42" condense="1,0.8,0.6,0.4">
                            <span font-weight="bold">
                                <utils method="toUpperCase">
                                    <xsl:value-of select="article/field[@key='name']/@value"/>
                                </utils>
                            </span>
                        </text>
                        <text color="white" font-family="Tahoma" font-size="28">
                            <br/>
                            <xsl:value-of select="article/field[@key='description']/@value"/>
                        </text>
                    </field>

                    <!-- Price -->
                    <field height="200" width="460" x="10" y="480">
                        <text color="white" align="right" font-family="Impact" font-size="120">
                            <xsl:if test="article/field[@key='sale']/@value = '1' or article/field[@key='sale']/@value = 'true'">
                                <xsl:attribute name="color">white</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="translate(article/field[@key='price']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Unit -->
                    <field height="32" width="100" x="370" y="728">
                        <text align="right" font-family="Verdana" font-size="26">
                            <xsl:value-of select="article/field[@key='unit']/@value"/>
                        </text>
                    </field>

                    <!-- Reference price -->
                    <field height="32" width="100" x="370" y="760">
                        <text align="right" font-family="Tahoma" font-size="26">
                            <xsl:value-of select="translate(article/field[@key='pricePerUnit']/@value, '.', ',')"/>
                        </text>
                    </field>

                    <!-- Label barcode -->
                    <field align="center" height="20" width="140" x="10" y="758">
                        <barcode autoscale="false" humanReadableEnabled="false" type="ean13">
                            <xsl:value-of select="article/@articleNumber"/>
                        </barcode>
                    </field>

                    <!-- NAN, Location, Clearance, UpdateTime -->
                    <field height="12" width="140" x="10" y="780">
                        <text align="center" font-family="Tahoma" font-size="10">
                            <xsl:value-of select="article/@articleNumber"/>
                        </text>
                    </field>

                </image>
            </xsl:when>


        </xsl:choose>

    </xsl:template>

</xsl:stylesheet>
