<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" encoding="utf-8" indent="yes"/>

    <xsl:variable name="base">
        <xsl:choose>
            <xsl:when test="/index">./</xsl:when>
            <xsl:when test="/general">./</xsl:when>
            <xsl:when test="/Utils">./</xsl:when>
            <xsl:when test="/TemplateNodes">./</xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <base>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$base"/>
                    </xsl:attribute>
                </base>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
                <link rel="stylesheet" type="text/css" media="screen, print"
                      href="css/help.css"/>
                <title>Image Rendering Reference</title>
                <script>
                    function handle_click_event ( obj ) {
                    test = obj;
                    if
                    (obj.parentNode.childNodes[3].style.display == 'block') {
                    obj.parentNode.childNodes[3].style.display = 'none';
                    obj.parentNode.style.paddingBottom = '0px';
                    }
                    else {
                    obj.parentNode.childNodes[3].style.display = 'block';
                    obj.parentNode.style.paddingBottom = '5px';
                    }
                    }
                </script>
            </head>
            <body style="position: relative; min-height: 100%; top: 0px;">
                <div id="top">
                    <div style="height:78px;">
                        <div style="position: relative; top: 30px;left:10px;">
                            <h1>Image Rendering Reference</h1>
                        </div>
                    </div>
                </div>

                <div style="clear:both;"/>
                <div id="leftcolumn">
                    <h2 class="left">Navigation:</h2>
                    <div class="entry">
                        <a href="index.html">Index</a>
                        <a href="general.html">General Information</a>
                        <a href="elements.html">Elements</a>
                        <a href="utils.html">Utils</a>
                        <a href="examples/categories.html">Examples</a>
                    </div>
                </div>
                <div id="main">
                    <xsl:apply-templates/>
                </div>

                <div class="footer">

                    <hr/>

                    <div class="company">
                        <p class="company1">imagotag, 2014</p>
                    </div>
                </div>
            </body>
        </html>

    </xsl:template>

    <xsl:template match="index">
        <h2 style="padding-top:20px;">Content</h2>
        <p>This documentation contains information about the image rendering
            process for the iMAGOTAG ESL service.
        </p>
        <p>
            It is separated in the following sections:
            <ul>
                <li>
                    <b>General Information</b>
                    -
                    Introduction and general information about the image rendering process.
                </li>
                <li>
                    <b>Elements</b>
                    -
                    Description of all elements and attributes that can be used to define a
                    template.
                </li>
                <li>
                    <b>Utils</b>
                    -
                    A documentation about all util methods that can be called inside a
                    template to modify content.
                </li>
                <li>
                    <b>Examples</b>
                    -
                    Several examples using different templates and records to generate an
                    image.
                </li>

            </ul>
        </p>
    </xsl:template>

    <xsl:template match="general">
        <h1>General</h1>
        <p>The image rendering process is based on
            <a href="http://www.w3schools.com/xsl/">XSL (EXtensible Stylesheet Language)</a>
            templates.
            <br/>
            The template is used to specify the fields, which should be rendered into the image.
            <br/>
            The individual image for the label is then generated by applying the template to a XML, which is based on
            the properties of the label and is expanded by a custom XML from the user.
        </p>

        <p>The following steps are executed when processing a template:</p>
        <ol>
            <li>
                Generating a record XML based on the label/task information and custom information provided by the user
            </li>
            <li>
                Applying the template (XSL) on the generated record XML. This results in a document containing the
                fields, specified in this reference and values referenced from the XML
            </li>
            <li>
                Rendering the image based on the previous output
            </li>
        </ol>
        <br/>
        <hr/>
        <br/>
        <div id="template">
            <h2>XSL Template</h2>
            <p>The XSL template will be applied to the XML record. After applying the template, a source for generating
                the image will be created.
                <br/>
                A template usually should have the following structure (example):
            </p>
            <div class="example">
                <h2 class="example">Template Example</h2>
                <div class="example_code notranslate">
                    <code>
                        &lt;?xml version="1.0" encoding="UTF-8"?&gt;
                        <br/>
                        &lt;xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                        xmlns:xsd="http://www.w3.org/2001/XMLSchema" version="1.0"&gt;
                        <br/>
                        &lt;xsl:template match="Record"&gt;
                        <br/>
                        Space for field definitions and XML record data referencing
                        <br/>
                        <br/>
                        &lt;/xsl:template&gt;
                        <br/>
                        &lt;/xsl:stylesheet&gt;
                        <br/>
                    </code>
                </div>
            </div>
        </div>
        <br/>
        <hr/>
        <br/>
        <div id="record">
            <h2>Record XML</h2>
            <p>A record XML is automatically generated before the image is rendered. The XML has the following
                structure:
            </p>
            <div class="example">
                <h2 class="example">Record Example</h2>
                <div class="example_code notranslate">
                    <code>
                        &lt;?xml version="1.0" encoding="UTF-8"?&gt;
                        <br/>
                        &lt;Record&gt;
                        <br/>
                        &lt;Label&gt;
                        <br/>
                        &lt;Id&gt;B1000000&lt;/Id&gt;
                        <br/>
                        &lt;LabelType&gt;iMAGOTAG 2.7&lt;/LabelType&gt;
                        <br/>
                        &lt;DisplayHeight&gt;176&lt;/DisplayHeight&gt;
                        <br/>
                        &lt;DisplayWidth&gt;264&lt;/DisplayWidth&gt;
                        <br/>
                        &lt;/Label&gt;
                        <br/>
                        &lt;Task&gt;
                        <br/>
                        &lt;CurrentDate&gt;11.09.2012&lt;/CurrentDate&gt;
                        <br/>
                        &lt;CurrentTime&gt;15:13:53&lt;/CurrentTime&gt;
                        <br/>
                        &lt;ExternalId&gt;0&lt;/ExternalId&gt;
                        <br/>
                        &lt;Page&gt;0&lt;/Page&gt;
                        <br/>
                        &lt;/Task&gt;
                        <br/>
                        &lt;/Record&gt;
                        <br/>
                    </code>
                </div>
            </div>
            <br/>
            The XML specified by the user gets appended after the "Task" element.
            <br/>
            This means every field this XML can be referenced in the XSL template using e.g.<code>&lt;xsl:value
            select="Label/Id"/&gt;</code>, references the ID of the label.
        </div>
        <br/>
        <hr/>
        <br/>
        <div id="utils">
            <h2>Utils</h2>
            <p>The template utils are methods provided by iMAGOTAG to manipulate text content for the generated image.
                See the
                <a href="utils.xml">utils</a>
                section for detailed information about the different supported methods, their parameters and their
                outputs.
            </p>
            <p>In order to call such a method it has to be defined in the template:</p>
            <div class="example">
                <h2 class="example">Utils Example</h2>
                <div class="example_code nottranslate">
                    <code>
                        &lt;utils method="toUpperCase"&gt;text&lt;/utils&gt;
                    </code>
                </div>
            </div>
            <p>The result of this example would be, that the generated image will output "TEXT" instead of "text".</p>
            <p>In case that the method takes multiple parameters, they have to be defined as attribute in the utils
                tag.
            </p>
            <div class="example">
                <h2 class="example">Utils Example with multiple arguments</h2>
                <div class="example_code nottranslate">
                    <code>
                        &lt;utils method="replace" arg1="x" arg2="s"&gt;text&lt;/utils&gt;
                    </code>
                </div>
            </div>
            <p>The output for this method will be "test" instead of "text".</p>
        </div>
        <br/>
        <hr/>
        <br/>
        <div id="css">
            <h2>CSS Support</h2>
            <p>The templates support the import of one or more CSS files in order to specify the attributes of the
                different fields. Each tag, except the root image tag, supports the HTML like attributes "id" and
                "class", to reference from the CSS file.
            </p>
            <p>The engine supports the definition of CSS1. The attributes used in the CSS file have the same identifier
                as the attributes in the template (e.g. in template: font-size="12", in css: font-size: 12;)
            </p>
            <p>In order to import a CSS file, a &lt;css&gt; tag and the "href" attribute have to be defined inside the
                root image tag. The "href" attribte specifies the relative path to the css file from the template file.
            </p>
            <p>For usage see the
                <a href="examples/css1.html">CSS Example</a>
                and the referenced
                <a href="css/example.css">CSS file</a>
            </p>

        </div>
    </xsl:template>

    <xsl:template match="Utils">
        <h1>
            <xsl:value-of select="@name"/>
        </h1>
        <xsl:for-each select="Method">
            <h2>
                <xsl:attribute name="id">
                    <xsl:value-of select="./@name"/>
                </xsl:attribute>
                <xsl:value-of select="./@name"/>
            </h2>
            <p>
                <xsl:value-of select="./@description"/>
            </p>

            <h3 style="font-size:140%;">Parameters</h3>
            <xsl:choose>
                <xsl:when test="count(./Parameter) = 0">
                    <p>No parameters</p>
                </xsl:when>
                <xsl:otherwise>
                    <table class="reference">
                        <tr>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Description</th>
                        </tr>
                        <xsl:for-each select="./Parameter">
                            <tr>
                                <td>
                                    <xsl:choose>
                                        <xsl:when test="position() = 1">
                                            Text Content
                                        </xsl:when>
                                        <xsl:otherwise>
                                            arg<xsl:value-of select="position() - 1"/>
                                        </xsl:otherwise>
                                    </xsl:choose>

                                </td>
                                <td>
                                    <xsl:value-of select="./@type"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./@description"/>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </table>
                </xsl:otherwise>

            </xsl:choose>
            <br/>
            <br/>
            <hr/>
            <xsl:if test="position() != last()">
                <br/>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="TemplateNodes">
        <ul style="list-style-type:circle;">
            <xsl:for-each select="Node">
                <li>
                    <h3>
                        <a>
                            <xsl:attribute name="href">fields/<xsl:value-of select="."/>.html
                            </xsl:attribute>
                            <xsl:value-of select="@key"/>
                        </a>
                    </h3>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>

    <xsl:template match="TemplateNode">
        <h1>The
            <span class="color_h1">&lt;<xsl:value-of select="@key"/>&gt;
            </span>
            Element
        </h1>
        <hr/>
        <div>
            <xsl:attribute name="id">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <h2>Description:</h2>
            <xsl:value-of select="./@description"/>
            <h3>
                <b>Multiple Occurrences allowed:</b>
                <xsl:text> </xsl:text><xsl:value-of select="@multipleOccurrences"/>
            </h3>
            <hr/>

            <h2>Attributes</h2>
            <xsl:choose>
                <xsl:when test="count(./AttributeList/Attribute) > 0">
                    <table class="reference">
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Inheritated</th>
                            <th>Possible Values</th>
                            <th>Default Value</th>
                            <th>Examples</th>
                        </tr>
                        <xsl:for-each select="./AttributeList/Attribute">
                            <tr>
                                <td>
                                    <b>
                                        <xsl:value-of select="./@name"/>
                                    </b>
                                </td>
                                <td>
                                    <xsl:value-of select="./@description"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./@inheritated"/>
                                </td>
                                <td>
                                    <xsl:value-of select="./@possibleValues"/>
                                </td>
                                <td>
                                    <xsl:choose>
                                        <xsl:when test="./@defaultValue != ''">
                                            <xsl:value-of select="./@defaultValue"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            No default value
                                        </xsl:otherwise>
                                    </xsl:choose>

                                </td>
                                <td>
                                    <xsl:choose>
                                        <xsl:when test="count(./Examples/Example) > 0">
                                            <xsl:for-each select="./Examples/Example">
                                                <a>
                                                    <xsl:attribute name="href">
                                                        <xsl:text>examples/</xsl:text><xsl:value-of select="./@id"/><xsl:text>.html</xsl:text>
                                                    </xsl:attribute>
                                                    <xsl:value-of select="./@id"/>
                                                </a>
                                                <xsl:if test="position() != last()">
                                                    <xsl:text>, </xsl:text>
                                                </xsl:if>
                                            </xsl:for-each>


                                        </xsl:when>
                                        <xsl:otherwise>
                                            -
                                        </xsl:otherwise>

                                    </xsl:choose>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </table>


                </xsl:when>
                <xsl:otherwise>
                    No attributes
                    <br/>
                </xsl:otherwise>
            </xsl:choose>

            <xsl:if test="@name = 'BARCODE'">
                <br/>
                <hr/>
                <h2>Barcode Types</h2>

                <table>
                    <tr>
                        <!-- 	<xsl:for-each select="./Barcodes/Barcode">
                                <td><a><xsl:attribute name="href">elements.xml?element=<xsl:value-of select="$element"/>#<xsl:value-of select="@name"/></xsl:attribute><xsl:value-of select="@key"/></a></td>
                            </xsl:for-each>

                             -->
                    </tr>
                </table>
                <hr/>
                <br/>
                <xsl:for-each select="./Barcodes/Barcode">
                    <div>
                        <xsl:attribute name="id">
                            <xsl:value-of select="@name"/>
                        </xsl:attribute>
                        <h2>
                            <xsl:value-of select="@key"/>
                        </h2>

                        <table class="reference">
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                                <th>Possible Values</th>
                                <th>Default Value</th>
                            </tr>
                            <xsl:for-each select="./AttributeList/Attribute">
                                <tr>
                                    <td>
                                        <b>
                                            <xsl:value-of select="./@name"/>
                                        </b>
                                    </td>
                                    <td>
                                        <xsl:value-of select="./@description"/>
                                    </td>
                                    <td>
                                        <xsl:value-of select="./@possibleValues"/>
                                    </td>
                                    <td>
                                        <xsl:choose>
                                            <xsl:when test="./@defaultValue != ''">
                                                <xsl:value-of select="./@defaultValue"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                No default value
                                            </xsl:otherwise>
                                        </xsl:choose>

                                    </td>
                                </tr>
                            </xsl:for-each>
                        </table>
                        <br/>
                        <br/>
                        <br/>
                        <br/>
                    </div>
                </xsl:for-each>

            </xsl:if>
            <br/>
            <hr/>
            <h2 id="childs">Child Elements</h2>

            <xsl:choose>
                <xsl:when test="count(./Childs/Child) > 0">
                    <table>
                        <tr>
                            <xsl:for-each select="./Childs/Child">
                                <td>
                                    <a>
                                        <xsl:attribute name="href">fields/<xsl:value-of select="@name"/>.html
                                        </xsl:attribute>
                                        <xsl:value-of select="@key"/>
                                    </a>
                                    <xsl:if test="position() != last()">
                                        <xsl:text> |</xsl:text>
                                    </xsl:if>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </table>
                </xsl:when>
                <xsl:otherwise>
                    <p>No child elements</p>
                </xsl:otherwise>
            </xsl:choose>
        </div>

        <xsl:if test="count(./Examples/Example) != 0">
            <h2>Examples</h2>
            <ul>
                <xsl:for-each select="./Examples/Example">
                    <li>
                        <a>
                            <xsl:attribute name="href">examples/<xsl:value-of select="@id"/>.html
                            </xsl:attribute>
                            <xsl:value-of select="@title"/>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
        <br/>
        <hr/>
        <xsl:if test="count(./Examples/Example) = 0">

        </xsl:if>
    </xsl:template>

    <xsl:template match="Categories">
        <ul style="list-style-type:circle;">
            <xsl:for-each select="Category">
                <li>
                    <h3>
                        <a>
                            <xsl:attribute name="href">examples/<xsl:value-of select="@id"/>.html
                            </xsl:attribute>
                            <xsl:value-of select="."/>
                        </a>
                    </h3>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>

    <xsl:template match="SingleCategory">
        <xsl:apply-templates select="Example"/>
    </xsl:template>

    <xsl:template match="Example">
        <div>
            <h2>
                <xsl:value-of select="Title"/>
            </h2>
            <p>
                <xsl:value-of select="./Description"/>
            </p>
            <ul>
                <li>Template:
                    <a>
                        <xsl:attribute name="href">
                            <xsl:value-of select="./Template"/>
                        </xsl:attribute>
                        <xsl:value-of select="./Template"/>
                    </a>
                </li>
                <li>Record:
                    <a>
                        <xsl:attribute name="href">
                            <xsl:value-of select="./Record"/>
                        </xsl:attribute>
                        <xsl:value-of select="./Record"/>
                    </a>
                </li>
            </ul>

            <br/>
            <div class="example" style="padding-top:10px;padding-left:5px;padding-right:5px;padding-bottom:0px">
                <h2 onclick="handle_click_event(this)" class="example">
                    <a>
                        <xsl:value-of select="Title"/> (Template)
                    </a>
                </h2>
                <div class="example_code nottranslate" style="display:none;">
                    <xsl:attribute name="id"><xsl:value-of select="Title"/>_template
                    </xsl:attribute>
                    <xsl:variable name="file">
                        ./<xsl:value-of select="./Template"/>
                    </xsl:variable>
                    <xsl:for-each select="document($file)/*">
                        <xsl:call-template name="node">
                            <xsl:with-param name="depth" select="0"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </div>
            </div>

            <xsl:if test="./Record != 'records/empty.xml'">
                <div class="example" style="padding-top:10px;padding-left:5px;padding-right:5px;padding-bottom:0px">
                    <h2 onclick="handle_click_event(this)" class="example">
                        <a>
                            <xsl:value-of select="Title"/> (Record)
                        </a>
                    </h2>
                    <div class="example_code nottranslate" style="display:none;">
                        <xsl:attribute name="id"><xsl:value-of select="Title"/>_record
                        </xsl:attribute>
                        <xsl:variable name="file">
                            ./<xsl:value-of select="./Record"/>
                        </xsl:variable>
                        <xsl:for-each select="document($file)/*">
                            <xsl:call-template name="node">
                                <xsl:with-param name="depth" select="0"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </div>
                </div>
            </xsl:if>
            <br/>
            <h2 style="font-size:160%;">Generated Image</h2>
            <img style="border:1px solid #021a40;">
                <xsl:attribute name="src">
                    <xsl:value-of select="concat('data:image/gif;base64,',./Image)"/>
                </xsl:attribute>
            </img>

            <xsl:if test="count(./ExecutionStatus/Element) != 0">
                <h3>Execution Status</h3>
                <table class="reference">
                    <tr>
                        <th>Execution Problem</th>
                    </tr>
                    <xsl:for-each select="./ExecutionStatus/Element">
                        <tr>
                            <td>
                                <xsl:value-of select="."/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </table>
            </xsl:if>
            <br/>
            <br/>
            <xsl:if test="position() != last()">
                <br/>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template name="node">
        <xsl:param name="depth"/>
        <div>
            <xsl:attribute name="style">margin-left: <xsl:value-of select="$depth"/>em;
            </xsl:attribute>

            &lt;<xsl:value-of select="name()"/>
            <xsl:for-each select="@*">
                <xsl:text> </xsl:text>
                <xsl:value-of select="name()"/>="<xsl:value-of select='.'/>"
            </xsl:for-each>
            &gt;
        </div>

        <div>
            <xsl:attribute name="style">margin-left: <xsl:value-of select="$depth + 1"/>em;
            </xsl:attribute>
            <xsl:value-of select="node()"/>
        </div>
        <xsl:for-each select="*">
            <xsl:call-template name="node">
                <xsl:with-param name="depth" select="$depth + 1"/>
            </xsl:call-template>
        </xsl:for-each>

        <div>
            <xsl:attribute name="style">margin-left: <xsl:value-of select="$depth"/>em;
            </xsl:attribute>
            &lt;/<xsl:value-of select="name()"/>&gt;
        </div>
    </xsl:template>

</xsl:stylesheet>

