package de.lcs.wep.rest.response;


import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.*;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Sönke Greve on 31.10.2014.
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "LabelInfoPagedResult")
public class LabelInfoPagedResult {

    public static final Logger logger = LogManager.getLogger(LabelInfoPagedResult.class);

    @XmlAttribute
    private int records;

    @XmlAttribute
    private int totalRecords;

    @XmlAttribute
    private int totalPages;

    @XmlAttribute
    private int page;

    @XmlAttribute
    private int recordsPerPage;

    @XmlElement(name = "LabelInfo", type = LabelInfo.class)
    private List<LabelInfo> labelInfos = new ArrayList<LabelInfo>();

    /**
     * Parses a valid xml string back into an object
     *
     * @param xml the valid xml string
     * @return an instance of this class
     * @throws javax.xml.bind.JAXBException
     */
    public static LabelInfoPagedResult fromXML(String xml) throws JAXBException {

        if(xml == null || xml.length() == 0)
        {
            logger.warn("Passed string is null or empty");
            return null;
        }

        JAXBContext context = JAXBContext.newInstance(LabelInfoPagedResult.class);
        Unmarshaller m = context.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        LabelInfoPagedResult result = (LabelInfoPagedResult) m.unmarshal(reader);
        return result;
    }

    public int getRecords() {
        return records;
    }

    public void setRecords(int records) {
        this.records = records;
    }

    public int getTotalRecords() {
        return totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public int getTotalPages() {
        return totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRecordsPerPage() {
        return recordsPerPage;
    }

    public void setRecordsPerPage(int recordsPerPage) {
        this.recordsPerPage = recordsPerPage;
    }

    public List<LabelInfo> getLabelInfos() {
        return labelInfos;
    }

    public void setLabelInfos(List<LabelInfo> labelInfos) {
        this.labelInfos = labelInfos;
    }
}
