package de.lcs.wep.rest.request.post.xml;

import de.lcs.wep.rest.AClient;
import de.lcs.wep.rest.Constants;
import de.lcs.wep.rest.request.post.APostImage;
import de.lcs.wep.rest.request.post.IPostRequest;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * Created by Sönke Greve on 20.10.2014.
 */
public class XmlPostImage extends APostImage implements IPostRequest {

    //    <?xml version="1.0" encoding="UTF-8" standalone="yes"?>" +
    //            "<TaskOrder title=\"Send image\">" +
    //            "<ImageTask labelId=\"%s\" page=\"%d\" preload=\"%b\">" +
    //            "<Image>%s</Image>" +
    //            "</ImageTask>" +
    //            "</TaskOrder>

     public XmlPostImage(AClient client, String labelID, String pngBase64) {
        super(client,labelID,pngBase64);
    }

    @Override
    public String getContentType() {
        return Constants.ContentType.XML.toString();
    }

    @Override
    public String getContent() {
        String raw = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>" +
                "<TaskOrder title=\"Send image\">" +
                "<ImageTask labelId=\"%s\" page=\"%d\" preload=\"%b\">" +
                "<Image>%s</Image>" +
                "</ImageTask>" +
                "</TaskOrder>";

        String xmlDeviceID = StringEscapeUtils.escapeXml11(super.getLabelID());
        //String xmlPngBase64 = StringEscapeUtils.escapeXml11(pngBase64);
        String result = String.format(raw, xmlDeviceID, super.getPage(), super.getDoPreload(), super.getImage());
        return result;
    }

}
