package de.lcs.wep.rest.request.post.json;

import de.lcs.wep.rest.AClient;
import de.lcs.wep.rest.Constants;
import de.lcs.wep.rest.request.post.APostImage;
import de.lcs.wep.rest.request.post.IPostRequest;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * Created by Sönke Greve on 20.10.2014.
 */
public class JsonPostImage extends APostImage implements IPostRequest {

    //        String raw = "{\"@title\":\"Send image\"," +
//                "\"ImageTask\":[{" +
//                "\"@labelId\":\"%s\"," +
//                "\"@page\":%d," +
//                "\"@preload\":%b," +
//                "\"Image\":\"%s\"" +
//                "}]}";

    public JsonPostImage(AClient client, String labelID, String pngBase64) {
        super(client,labelID,pngBase64);
    }

    @Override
    public String getContentType() {
        return Constants.ContentType.JSON.toString();
    }

    @Override
    public String getContent() {

        String raw = "{\"@title\":\"Send image\"," +
                "\"ImageTask\":" +
                "[{\"@labelId\":\"%s\"," +
                "\"@page\":%d," +
                "\"@preload\":%b," +
                "\"Image\":\"%s\"}]}";

        String jsonDeviceID = StringEscapeUtils.escapeJson(super.getLabelID());
        String jsonPngBase64 = StringEscapeUtils.escapeJson(super.getImage());
        String result = String.format(raw, jsonDeviceID, super.getPage(), super.getDoPreload(), jsonPngBase64);

        return result;
    }
}
