package de.lcs.wep.rest.request.post.json;

import de.lcs.wep.rest.AClient;
import de.lcs.wep.rest.Constants;
import de.lcs.wep.rest.request.post.APostArticle;
import de.lcs.wep.rest.request.post.IPostRequest;
import de.lcs.wep.rest.tools.Format;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * Created by Sönke Greve on 20.10.2014.
 */
public class JsonPostArticle extends APostArticle implements IPostRequest {

    public JsonPostArticle(AClient client, String labelID, int articleNumber, String articleName, float articlePrice) {
        super(client, labelID, articleNumber, articleName, articlePrice);
    }

    @Override
    public String getContentType() {
        return Constants.ContentType.JSON.toString();
    }

    @Override
    public String getContent() {

        String raw = "{\"@title\":\"Show Article %s on label %s\"," +
                "\"TemplateTask\":[{" +
                "\"@labelId\": \"%s\"," +
                "\"@externalId\": \"1\"," +
                "\"@template\": \"%s\"," +
                "\"article\": [{" +
                "\"@articleNumber\": \"%d\"," +
                "\"field\": [" +
                "{" +
                "\"@key\": \"name\"," +
                "\"@value\": \"%s\"" +
                "}," +
                "{" +
                "\"@key\": \"price\"," +
                "\"@value\": \"%s %s\"" +
                "}" +
                "]" +
                "}]" +
                "}]" +
                "}";

        // encode the strings used in an xml-property-value expression
        // format number into strings and retrieve the currency symbol
        int num = super.getArticleNumber();
        String xmlLabelID = StringEscapeUtils.escapeXml11(super.getLabelID());
        String xmlTemplate = StringEscapeUtils.escapeXml11(super.getTemplate());
        String xmlName = StringEscapeUtils.escapeXml11(super.getArticleName());
        String strPrice = Format.price(super.getArticlePrice());
        String symbol = java.util.Currency.getInstance(super.getCurrency().getCode()).getSymbol();
        symbol = "EUR";

        String result = String.format(raw, num, xmlLabelID, xmlLabelID, xmlTemplate, num, xmlName, strPrice, symbol);
        return result;
    }


}
