package de.lcs.wep.rest.request.post;

import de.lcs.wep.calendar.Event;
import de.lcs.wep.rest.AClient;
import de.lcs.wep.rest.Constants;
import de.lcs.wep.rest.request.Request;

import java.util.List;

/**
 * Created by Sönke Greve on 23.10.2014.
 */
public abstract class APostRoomSchedule extends Request {

    public static enum ROOM_STATE{
        FREE("Frei"),
        OCCUPIED("Belegt");

        private final String text;

        /**
         * @param text
         */
        private ROOM_STATE(final String text) {
            this.text = text;
        }

        /* (non-Javadoc)
         * @see java.lang.Enum#toString()
         */
        @Override
        public String toString() {
            return text;
        }
    }

    private String labelID;
    private String roomName;
    private String template;
    private List<Event> events;

    public APostRoomSchedule(AClient client, String labelID, String roomName, List<Event> events, String template) {
        super(client, Constants.REQUEST_TYPE.POST, Constants.METHOD.POST_SERVICE_TASK);
        this.labelID = labelID;
        this.roomName = roomName;
        this.template = template;
        this.events = events;
    }

    public String getLabelID() {
        return labelID;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public String getRoomName() {
        return roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public List<Event> getEvents() {
        return events;
    }
}
