package de.lcs.wep.rest.request.post;

import de.lcs.wep.rest.AClient;
import de.lcs.wep.rest.Constants;
import de.lcs.wep.rest.request.Request;

/**
 * Created by Sönke Greve on 20.10.2014.
 */
public abstract class APostImage extends Request {

    private String labelID;
    private String pngBase64;
    private boolean doPreload;
    private int page;


    public APostImage(AClient client, String labelID, String pngBase64) {
        super(client, Constants.REQUEST_TYPE.POST, Constants.METHOD.POST_SERVICE_TASK);
        this.labelID = labelID;
        this.pngBase64 = pngBase64;
        this.doPreload = false;
        this.page = 0;
    }

    public String getLabelID() {
        return labelID;
    }

    public String getImage() {
        return pngBase64;
    }

    public void setImage(String pngBase64) {
        this.pngBase64 = pngBase64;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    public void setDoPreload(boolean doPreload) {
        this.doPreload = doPreload;
    }

    public boolean getDoPreload() {
        return doPreload;
    }

}
