package de.lcs.wep.rest.request.post;

import de.lcs.wep.rest.AClient;
import de.lcs.wep.rest.Constants;
import de.lcs.wep.rest.request.Request;
import org.jscience.economics.money.Currency;

/**
 * Created by Sönke Greve on 22.10.2014.
 */
public abstract class APostArticle extends Request {

    private String labelID;
    private String templateFilename;
    private int articleNumber;
    private String articleName;
    private float articlePrice;
    private Currency currency;

    public APostArticle(AClient client, String labelID, int articleNumber, String articleName, float articlePrice) {
        super(client, Constants.REQUEST_TYPE.POST, Constants.METHOD.POST_SERVICE_TASK);
        this.labelID = labelID;
        this.articleNumber = articleNumber;
        this.articleName = articleName;
        this.articlePrice = articlePrice;
        this.templateFilename = Constants.DEFAULT_XSL_TEMPLATE;
        this.currency = Currency.EUR;
    }

    public String getLabelID() {
        return labelID;
    }

    public void setTemplate(String filename) {
        this.templateFilename = filename;
    }

    public String getTemplate() {
        return templateFilename;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public String getArticleName() {
        return articleName;
    }

    public void setArticlePrice(float price) {
        this.articlePrice = price;
    }

    public float getArticlePrice() {
        return articlePrice;
    }

    public void setArticleName(String articleName) {
        this.articleName = articleName;
    }

    public int getArticleNumber() {
        return articleNumber;
    }


    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Currency getCurrency() {
        return currency;
    }


    public void setArticleNumber(int articleNumber) {
        this.articleNumber = articleNumber;
    }
}
