package de.lcs.wep.rest;

import de.lcs.wep.calendar.Event;
import de.lcs.wep.rest.request.GetReq;
import de.lcs.wep.rest.request.Request;
import de.lcs.wep.rest.request.post.APostArticle;
import de.lcs.wep.rest.request.post.APostImage;
import de.lcs.wep.rest.request.post.APostRoomSchedule;
import de.lcs.wep.rest.request.post.json.JsonPostArticle;
import de.lcs.wep.rest.request.post.json.JsonPostImage;
import de.lcs.wep.rest.request.post.xml.XmlPostArticle;
import de.lcs.wep.rest.request.post.xml.XmlPostImage;
import de.lcs.wep.rest.request.post.xml.XmlPostRoomSchedule;
import de.lcs.wep.rest.response.LabelInfo;
import de.lcs.wep.rest.response.LabelInfoPagedResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.xml.bind.JAXBException;
import java.util.List;
import java.util.Properties;

/**
 * Created by Sönke Greve on 20.10.2014.
 */
public class WePClient extends AClient {

    private static Logger logger = LogManager.getLogger(WePClient.class);

    public static WePClient fromProperties(Properties props) {
        String host = props.getProperty("host", "localhost");
        logger.debug("Read property host: " + host);
        String strPort = props.getProperty("port", "8001");
        logger.debug("Read property port: " + strPort);
        int port = Integer.valueOf(strPort);
        String user = props.getProperty("user", "admin");
        logger.debug("Read property user: " + user);
        String pass = props.getProperty("password", "admin");
        logger.debug("Read property pass: " + pass);

        WePClient client = new WePClient(host, port, user, pass);
        // setContentType
        return client;
    }

    private Constants.ContentType contentType = Constants.ContentType.XML;

    public WePClient(String host, int port) {
        super(host, port);
    }

    public WePClient(String host, int port, String user, String password) {
        super(host, port, user, password);
    }

    public List<LabelInfo> getLabelInfos() throws JAXBException {
        return getLabelInfos(-1, -1);
    }

    public List<LabelInfo> getLabelInfos(int page, int recordsPerPage) throws JAXBException {

        Request request = GetReq.createLabelInfo(this);
        if (page != -1) {
            request.addUrlParam("page", String.valueOf(page));
        }
        if (recordsPerPage != -1) {
            request.addUrlParam("recordsPerPage", String.valueOf(recordsPerPage));
        }

        String response = request.send();
        logger.debug("Received response: " + response);
        LabelInfoPagedResult labelInfoPagedResult = LabelInfoPagedResult.fromXML(response);
        List<LabelInfo> result = null;
        if (labelInfoPagedResult != null) {
            result = labelInfoPagedResult.getLabelInfos();
        } else {
            logger.warn("Couldn't create instance from label info response (=null). Skipping update.");
        }
        return result;
    }

    public String postImage(String deviceID, String pngBase64) {
        APostImage postImage = null;
        switch (contentType) {
            case JSON:
                postImage = new JsonPostImage(this, deviceID, pngBase64);
                break;
            case XML:
                postImage = new XmlPostImage(this, deviceID, pngBase64);
                break;
        }

        String response = postImage.send();
        return response;
    }

    public String postArticle(String labelID, int articleNumber, String articleName, float articlePrice) {
        APostArticle postArticle = null;
        switch (contentType) {
            case JSON:
                postArticle = new JsonPostArticle(this, labelID, articleNumber, articleName, articlePrice);
                break;
            case XML:
                postArticle = new XmlPostArticle(this, labelID, articleNumber, articleName, articlePrice);
                break;
        }

        String response = postArticle.send();
        return response;
    }

    public String postRoomSchedule(String labelID, String roomName, List<Event> events, boolean useAlias, String template) throws Exception {
        APostRoomSchedule postRoomSchedule = null;
        switch (contentType) {
            case JSON:
                throw new Exception("JSON request not yet implemented");
                // break;
            case XML:
                postRoomSchedule = new XmlPostRoomSchedule(this, labelID, roomName, events, useAlias, template);
                break;
        }

        String response = postRoomSchedule.send();
        return response;
    }

    public Constants.ContentType getContentType() {
        return contentType;
    }

    public void setContentType(Constants.ContentType contentType) {
        this.contentType = contentType;
    }
}
