package de.lcs.wep.rest;

/**
 * Created by Sönke Greve on 20.10.2014.
 */
public class Constants {

    public static final String DEFAULT_XSL_TEMPLATE = "default.xsl";

    public enum REQUEST_TYPE {
        GET, POST
    }

    public enum ContentType {
        XML {
            public String toString() {
                return "application/xml";
            }
        },
        JSON {
            public String toString() {
                return "application/json";
            }
        }
    }

    public enum REQUEST_PROPERTY {
        AUTHORIZATION {
            public String toString() {
                return "Authorization";
            }
        },
        CONTENT_TYPE{
            public String toString() {
                return "Content-Type";
            }
        }

    }

    /**
     * Defines the REST Request methods available in the WeP <i>(Wireless ePaper)</i> environment.<br/>
     * This is equivalent to the directory resource string on the server determining the method to be called, e.g.:<br/>
     * the <i>/service/labelinfo</i> part from <i>http://rest-server.com/service/labelinfo?param1=1&param2=2</i>
     */
    public enum METHOD {
        GET_LABEL_INFO {
            public String toString() {
                return "/service/labelinfo";
            }
        },
        POST_SERVICE_TASK {
            public String toString() {
                return "/service/task";
            }
        }
    }

    public enum ROOMS{
        TEAM01{
            public String toString() {
                return "Team 01";
            }
        },
        TEAM02{
            public String toString() {
                return "Team 02";
            }
        },
        TEAM03{
            public String toString() {
                return "Team 03";
            }
        },
        TEAM04{
            public String toString() {
                return "Team 04";
            }
        }
    }

}
