package de.lcs.wep.utils;


import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * Created by Sönke Greve on 30.10.2014.
 */
public class Utils {

    public static Logger logger = LogManager.getLogger(Utils.class);

    /**
     * Reads property file
     * @return Properties if successful, otherwise null
     */
    public static Properties readProperties(String filename){
        // load resource calendar id's and seriveaccountid
        Properties props = new Properties();
        FileInputStream in = null;

        try {
            // Load resource properties file. Close in finally (always executed)
            in = new FileInputStream(filename);
            props.load(in);
            logger.debug("All properties were read successfully. Total lines: " + props.size());
            return props;

        } catch (Exception e) {
            logger.error("Problem reading properties file detected. Please make sure the file /resources.properties exists and is accessible: ", e);
            logger.info("Are you in the right working directory?");
            return null;
        }
        finally{
            if(in != null){
                try {
                    in.close();
                } catch (IOException e) {
                    logger.fatal("Problem closing property file: ", e);
                }
            }
        }
    }

}
