package de.lcs.wep.calendar;

import com.google.api.client.util.DateTime;

/**
 * class to store calendar resource event informations
 *
 * @author raffael
 */
public class Event {

    private String id;
    private String owner;
    private String visibility;
    private String subject;
    private DateTime start;
    private DateTime end;

    public Event(String id, String owner, String visibility, String subject, DateTime start, DateTime end) { // String res,
        this.id = id;
        this.owner = owner;
        this.visibility = visibility;
        this.subject = subject;
        this.start = start;
        this.end = end;
    }

    public String getId() {
        return id;
    }

    public String getOwner() {
        return owner;
    }

    public String getSubject() {
        return subject;
    }

    public DateTime getStart() {
        return start;
    }

    public DateTime getEnd() {
        return end;
    }

    @Override
    public String toString() {
        String raw = "id=%s, subject=%s, owner=%s, start=%s, end=%s, visibility=%s";
        String result = String.format(raw, id, subject, owner, start, end, visibility);
        return result;
    }

    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false; // different class
        }

        Event other = (Event) obj;

        if (this.id == null ^ other.id == null) {
            return false;
        }
        if (this.owner == null ^ other.owner == null) {
            return false;
        }
        if (this.visibility == null ^ other.visibility == null) {
            return false;
        }
        if (this.subject == null ^ other.subject == null) {
            return false;
        }
        if (this.start == null ^ other.start == null) {
            return false;
        }
        if (this.end == null ^ other.end == null) {
            return false;
        }


        if (id instanceof String && !id.equals(other.id)) {
            return false;
        }
        if (owner instanceof String &&  !owner.equals(other.owner)) {
            return false;
        }
        if (visibility instanceof String && !visibility.equals(other.visibility)) {
            return false;
        }
        if (subject instanceof String && !subject.equals(other.subject)) {
            return false;
        }
        if (start instanceof DateTime && !start.equals(other.start)) {
            return false;
        }
        if (end instanceof DateTime && !end.equals(other.end)) {
            return false;
        }

        return true;
    }

    public Event clone() {
        Event result = new Event(new String(id), new String(owner), new String(visibility), new String(subject), new DateTime(start.getValue()), new DateTime(end.getValue()));
        return result;
    }
}