/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TemplateCompletion
extends AbstractCompletion
implements ParameterizedCompletion {
    private List pieces;
    private String replacementText;
    private String definitionString;
    private List params;

    public TemplateCompletion(CompletionProvider completionProvider, String string, String string2) {
        super(completionProvider);
        this.replacementText = string;
        this.definitionString = string2;
        this.pieces = new ArrayList(3);
        this.params = new ArrayList(3);
    }

    public void addTemplatePiece(TemplatePiece templatePiece) {
        this.pieces.add(templatePiece);
        if (templatePiece.isParam) {
            Object var2_2 = null;
            ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter(var2_2, templatePiece.text);
            this.params.add(parameter);
        }
    }

    private String getPieceText(int n, String string) {
        String string2 = null;
        TemplatePiece templatePiece = (TemplatePiece)this.pieces.get(n);
        if (templatePiece.id != null) {
            String string3 = templatePiece.id;
            for (int i = 0; i < this.pieces.size(); ++i) {
                templatePiece = (TemplatePiece)this.pieces.get(i);
                if (!string3.equals(templatePiece.id)) continue;
                string2 = templatePiece.text;
                break;
            }
        } else {
            string2 = templatePiece.text;
        }
        if (string2.indexOf(10) > -1) {
            string2 = string2.replaceAll("\n", "\n" + string);
        }
        return string2;
    }

    public String getReplacementText() {
        return this.replacementText;
    }

    public String getSummary() {
        return null;
    }

    public String getDefinitionString() {
        return this.definitionString;
    }

    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent jTextComponent, boolean bl) {
        int n;
        ParameterizedCompletionInsertionInfo parameterizedCompletionInsertionInfo = new ParameterizedCompletionInsertionInfo();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = jTextComponent.getCaretPosition();
        int n3 = this.getParamCount();
        int n4 = n2;
        Position position = null;
        try {
            position = jTextComponent.getDocument().createPosition(n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        parameterizedCompletionInsertionInfo.setCaretRange(n4, position);
        int n5 = 0;
        Document document = jTextComponent.getDocument();
        String string = null;
        try {
            string = RSyntaxUtilities.getLeadingWhitespace(document, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            string = "";
        }
        int n6 = n2;
        for (n = 0; n < this.pieces.size(); ++n) {
            TemplatePiece templatePiece = (TemplatePiece)this.pieces.get(n);
            String string2 = this.getPieceText(n, string);
            stringBuffer.append(string2);
            int n7 = n6 + string2.length();
            if (templatePiece.isParam) {
                parameterizedCompletionInsertionInfo.addReplacementLocation(n6, n7);
                if (n5 == 0) {
                    n5 = string2.length();
                }
            }
            n6 = n7;
        }
        n = n3 > 0 ? n2 + n5 : n2;
        parameterizedCompletionInsertionInfo.setInitialSelection(n2, n);
        parameterizedCompletionInsertionInfo.setTextToInsert(stringBuffer.toString());
        return parameterizedCompletionInsertionInfo;
    }

    public ParameterizedCompletion.Parameter getParam(int n) {
        return (ParameterizedCompletion.Parameter)this.params.get(n);
    }

    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    public String toString() {
        return this.getDefinitionString();
    }

    public static class TemplatePiece {
        private String id;
        private String text;
        private boolean isParam;

        public TemplatePiece(String string, String string2, boolean bl) {
            this.id = string;
            this.text = string2;
            this.isParam = bl;
        }
    }
}

