/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterChoicesProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;
import org.fife.ui.autocomplete.SortByRelevanceComparator;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

public class ParameterizedCompletionChoicesWindow
extends JWindow {
    private AutoCompletion ac;
    private JList list;
    private DefaultListModel model;
    private List choicesListList;
    private JScrollPane sp;
    private static final Comparator sortByRelevanceComparator = new SortByRelevanceComparator();

    public ParameterizedCompletionChoicesWindow(Window window, AutoCompletion autoCompletion, final ParameterizedCompletionDescriptionToolTip parameterizedCompletionDescriptionToolTip) {
        super(window);
        this.ac = autoCompletion;
        ComponentOrientation componentOrientation = autoCompletion.getTextComponentOrientation();
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        if (autoCompletion.getParamChoicesRenderer() != null) {
            this.list.setCellRenderer(autoCompletion.getParamChoicesRenderer());
        }
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    parameterizedCompletionDescriptionToolTip.insertSelectedChoice();
                }
            }
        });
        this.sp = new JScrollPane(this.list);
        this.setContentPane(this.sp);
        this.applyComponentOrientation(componentOrientation);
        this.setFocusableWindowState(false);
        PopupWindowDecorator popupWindowDecorator = PopupWindowDecorator.get();
        if (popupWindowDecorator != null) {
            popupWindowDecorator.decorate(this);
        }
    }

    public String getSelectedChoice() {
        Completion completion = (Completion)this.list.getSelectedValue();
        return completion == null ? null : completion.toString();
    }

    public void incSelection(int n) {
        int n2 = this.list.getSelectedIndex();
        n2 = (n2 += n) <= 0 ? this.model.getSize() - 1 : (n2 %= this.model.getSize());
        this.list.setSelectedIndex(n2);
        this.list.ensureIndexIsVisible(n2);
    }

    public void initialize(ParameterizedCompletion parameterizedCompletion) {
        CompletionProvider completionProvider = parameterizedCompletion.getProvider();
        ParameterChoicesProvider parameterChoicesProvider = completionProvider.getParameterChoicesProvider();
        if (parameterChoicesProvider == null) {
            this.choicesListList = null;
            return;
        }
        int n = parameterizedCompletion.getParamCount();
        this.choicesListList = new ArrayList(n);
        JTextComponent jTextComponent = this.ac.getTextComponent();
        for (int i = 0; i < n; ++i) {
            ParameterizedCompletion.Parameter parameter = parameterizedCompletion.getParam(i);
            List list = parameterChoicesProvider.getParameterChoices(jTextComponent, parameter);
            this.choicesListList.add(list);
        }
    }

    public void setLocationRelativeTo(Rectangle rectangle) {
        Rectangle rectangle2 = Util.getScreenBoundsForPoint(rectangle.x, rectangle.y);
        int n = rectangle.y + rectangle.height + 5;
        int n2 = rectangle.x;
        if (n2 < rectangle2.x) {
            n2 = rectangle2.x;
        } else if (n2 + this.getWidth() > rectangle2.x + rectangle2.width) {
            n2 = rectangle2.x + rectangle2.width - this.getWidth();
        }
        this.setLocation(n2, n);
    }

    public void setParameter(int n, String string) {
        this.model.clear();
        ArrayList<Completion> arrayList = new ArrayList<Completion>();
        if (this.choicesListList != null && n >= 0 && n < this.choicesListList.size()) {
            int n2;
            Object object;
            Object object2;
            List list = (List)this.choicesListList.get(n);
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    Completion completion = (Completion)object2.next();
                    object = completion.getReplacementText();
                    if (string != null && !Util.startsWithIgnoreCase((String)object, string)) continue;
                    arrayList.add(completion);
                }
            }
            object2 = null;
            object2 = sortByRelevanceComparator;
            Collections.sort(arrayList, object2);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.model.addElement(arrayList.get(n2));
            }
            n2 = Math.min(this.model.size(), 10);
            this.list.setVisibleRowCount(n2);
            if (n2 == 0 && this.isVisible()) {
                this.setVisible(false);
            } else if (n2 > 0) {
                object = this.getPreferredSize();
                if (((Dimension)object).width < 150) {
                    this.setSize(150, ((Dimension)object).height);
                } else {
                    this.pack();
                }
                if (this.sp.getVerticalScrollBar() != null && this.sp.getVerticalScrollBar().isVisible()) {
                    object = this.getSize();
                    int n3 = ((Dimension)object).width + this.sp.getVerticalScrollBar().getWidth() + 5;
                    this.setSize(n3, ((Dimension)object).height);
                }
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl && this.list.getVisibleRowCount() == 0) {
                return;
            }
            super.setVisible(bl);
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

