/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.VariableCompletion;

public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List params;
    private String returnValDesc;

    public FunctionCompletion(CompletionProvider completionProvider, String string, String string2) {
        super(completionProvider, string, string2);
    }

    protected void addDefinitionString(StringBuffer stringBuffer) {
        stringBuffer.append("<html><b>");
        stringBuffer.append(this.getDefinitionString());
        stringBuffer.append("</b>");
    }

    protected void addParameters(StringBuffer stringBuffer) {
        int n = this.getParamCount();
        if (n > 0) {
            stringBuffer.append("<b>Parameters:</b><br>");
            stringBuffer.append("<center><table width='90%'><tr><td>");
            for (int i = 0; i < n; ++i) {
                ParameterizedCompletion.Parameter parameter = this.getParam(i);
                stringBuffer.append("<b>");
                stringBuffer.append(parameter.getName() != null ? parameter.getName() : parameter.getType());
                stringBuffer.append("</b>&nbsp;");
                String string = parameter.getDescription();
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            stringBuffer.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            stringBuffer.append(this.returnValDesc);
            stringBuffer.append("</td></tr></table></center><br><br>");
        }
    }

    public String getDefinitionString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getType();
        if (string != null) {
            stringBuffer.append(string).append(' ');
        }
        stringBuffer.append(this.getName());
        CompletionProvider completionProvider = this.getProvider();
        char c = completionProvider.getParameterListStart();
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        for (n = 0; n < this.getParamCount(); ++n) {
            ParameterizedCompletion.Parameter parameter = this.getParam(n);
            string = parameter.getType();
            String string2 = parameter.getName();
            if (string != null) {
                stringBuffer.append(string);
                if (string2 != null) {
                    stringBuffer.append(' ');
                }
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (n >= this.params.size() - 1) continue;
            stringBuffer.append(completionProvider.getParameterListSeparator());
        }
        n = completionProvider.getParameterListEnd();
        if (n != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent jTextComponent, boolean bl) {
        int n;
        ParameterizedCompletionInsertionInfo parameterizedCompletionInsertionInfo = new ParameterizedCompletionInsertionInfo();
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.getProvider().getParameterListStart());
        }
        int n2 = jTextComponent.getCaretPosition() + stringBuffer.length();
        int n3 = this.getParamCount();
        int n4 = n2;
        Position position = null;
        try {
            position = jTextComponent.getDocument().createPosition(n2 - stringBuffer.length());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        parameterizedCompletionInsertionInfo.setCaretRange(n4, position);
        int n5 = 0;
        int n6 = n2;
        for (n = 0; n < n3; ++n) {
            ParameterizedCompletion.Parameter parameter = this.getParam(n);
            String string = this.getParamText(parameter);
            if (n == 0) {
                n5 = string.length();
            }
            stringBuffer.append(string);
            int n7 = n6 + string.length();
            parameterizedCompletionInsertionInfo.addReplacementLocation(n6, n7);
            String string2 = this.getProvider().getParameterListSeparator();
            if (n >= n3 - 1 || string2 == null) continue;
            stringBuffer.append(string2);
            n6 = n7 + string2.length();
        }
        stringBuffer.append(this.getProvider().getParameterListEnd());
        n = n3 > 0 ? n2 + n5 : n2;
        parameterizedCompletionInsertionInfo.setInitialSelection(n2, n);
        parameterizedCompletionInsertionInfo.setTextToInsert(stringBuffer.toString());
        return parameterizedCompletionInsertionInfo;
    }

    public ParameterizedCompletion.Parameter getParam(int n) {
        return (ParameterizedCompletion.Parameter)this.params.get(n);
    }

    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    private String getParamText(ParameterizedCompletion.Parameter parameter) {
        String string = parameter.getName();
        if (string == null && (string = parameter.getType()) == null) {
            string = "arg";
        }
        return string;
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addDefinitionString(stringBuffer);
        if (!this.possiblyAddDescription(stringBuffer)) {
            stringBuffer.append("<br><br><br>");
        }
        this.addParameters(stringBuffer);
        this.possiblyAddDefinedIn(stringBuffer);
        return stringBuffer.toString();
    }

    public String getToolTipText() {
        String string = this.getSummary();
        if (string == null) {
            string = this.getDefinitionString();
        }
        return string;
    }

    public void setParams(List list) {
        if (list != null) {
            this.params = new ArrayList(list);
        }
    }

    public void setReturnValueDescription(String string) {
        this.returnValDesc = string;
    }
}

