/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.xml;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.XMLValidationResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLValidator {
    static ESLLogger logger = ESLLogger.getLogger(XMLValidator.class);
    private XMLReader reader;
    private XMLReader xsdValidationReader;

    public XMLValidator(String xsdFile) throws InitializationException {
        ByteArrayInputStream localByteArrayInputStream = null;
        try {
            this.reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            localByteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)XMLValidator.class.getResourceAsStream("/xsd/" + xsdFile)));
            SAXParserFactory localSAXParserFactory = SAXParserFactory.newInstance();
            localSAXParserFactory.setValidating(true);
            this.xsdValidationReader = localSAXParserFactory.newSAXParser().getXMLReader();
            this.xsdValidationReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            this.xsdValidationReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", localByteArrayInputStream);
        }
        catch (Exception exc) {
            try {
                throw new InitializationException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(localByteArrayInputStream);
                throw throwable;
            }
        }
        StreamUtils.close(localByteArrayInputStream);
    }

    public XMLValidationResult validateXML(String xmlString) {
        return this.validateXML(new InputSource(new ByteArrayInputStream(xmlString.getBytes())));
    }

    public XMLValidationResult validateXML(InputStream inputStream) {
        return this.validateXML(new InputSource(inputStream));
    }

    public XMLValidationResult validateXML(InputSource inputSource) {
        XMLValidationResult result = new XMLValidationResult();
        this.reader.setErrorHandler(result.getErrorHandler());
        try {
            this.reader.parse(inputSource);
        }
        catch (Exception exc) {
            logger.info("Error validating XML: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLValidationResult validate(Source xsltSource, Source xmlSource) {
        XMLValidationResult result = new XMLValidationResult();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setErrorListener(result.getErrorHandler());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Transformer transformer = null;
        try {
            transformer = xsltSource == null ? transformerFactory.newTransformer() : transformerFactory.newTemplates(xsltSource).newTransformer();
            transformer.setErrorListener(result.getErrorHandler());
            transformer.setOutputProperty("indent", "yes");
            StreamResult domResult = new StreamResult(outputStream);
            transformer.transform(xmlSource, domResult);
            this.xsdValidationReader.setErrorHandler(result.getErrorHandler());
            this.xsdValidationReader.setContentHandler(result.getErrorHandler());
            this.xsdValidationReader.parse(new InputSource(new ByteArrayInputStream(outputStream.toByteArray())));
        }
        catch (Exception exc) {
            logger.info("Error validating XML: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
            result.getErrorHandler().fatalError(exc);
        }
        finally {
            StreamUtils.close(outputStream);
        }
        return result;
    }
}

