/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.xml;

import at.mrdevelopment.toolkit.ExecutionStatusElement;
import at.mrdevelopment.toolkit.xml.XMLValidationResult;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationErrorHandler
extends DefaultHandler
implements ErrorListener {
    private final XMLValidationResult result;
    private boolean errorOcurred = false;
    private boolean saxError = false;

    public XMLValidationErrorHandler(XMLValidationResult result) {
        this.result = result;
    }

    private void handleWarning(SAXParseException exception) {
        this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.WARNING);
        this.parseException(exception);
    }

    @Override
    public void warning(SAXParseException exc) throws SAXException {
        this.handleWarning(exc);
    }

    private void handleError(SAXParseException exception) {
        this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.ERROR);
        this.parseException(exception);
    }

    @Override
    public void error(SAXParseException exc) throws SAXException {
        this.handleError(exc);
    }

    private void handleFatalError(SAXParseException exception) {
        this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.ERROR);
        this.parseException(exception);
    }

    @Override
    public void fatalError(SAXParseException exc) throws SAXException {
        this.handleFatalError(exc);
    }

    private void parseException(TransformerException exc) {
        if (exc.getLocator() != null) {
            this.result.setLineNumber(exc.getLocator().getLineNumber());
            this.result.setColumnNumber(exc.getLocator().getColumnNumber());
        }
        this.result.setMessage(exc.getMessage());
        this.errorOcurred = true;
    }

    private void parseException(SAXParseException exc) {
        this.result.setLineNumber(exc.getLineNumber());
        this.result.setColumnNumber(exc.getColumnNumber());
        this.result.setMessage(exc.getMessage());
        this.errorOcurred = true;
        this.saxError = true;
    }

    public boolean isErrorOcurred() {
        return this.errorOcurred;
    }

    public boolean isSaxError() {
        return this.saxError;
    }

    private void handleWarning(TransformerException exception) {
        this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.WARNING);
        this.parseException(exception);
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.handleWarning(exception);
    }

    private void handleError(TransformerException exception) {
        this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.ERROR);
        this.parseException(exception);
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.handleError(exception);
    }

    private void handleFatalError(TransformerException exception) {
        this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.ERROR);
        this.parseException(exception);
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.handleFatalError(exception);
    }

    public void fatalError(Exception exception) {
        if (exception instanceof TransformerException) {
            this.handleFatalError((TransformerException)exception);
        } else if (exception instanceof SAXParseException) {
            this.handleFatalError((SAXParseException)exception);
        } else {
            this.result.setErrorLevel(ExecutionStatusElement.ErrorLevel.ERROR);
            this.result.setMessage(exception.getMessage());
            this.errorOcurred = true;
        }
    }
}

