/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tree;

import at.mrdevelopment.toolkit.tree.ConstructiblePath;
import at.mrdevelopment.toolkit.tree.Path;
import at.mrdevelopment.toolkit.tree.TreeException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TreeNode<T, M> {
    private String id;
    private T nodeElement;
    private M metaElement;
    private TreeNode<T, M> parent = null;
    private Map<String, TreeNode<T, M>> children = new HashMap<String, TreeNode<T, M>>();
    private Path nodePath;

    public TreeNode(String id, T nodeElement, M metaElement) {
        this.id = id;
        this.metaElement = metaElement;
        this.nodeElement = nodeElement;
        this.constructNodePath();
    }

    public String getId() {
        return this.id;
    }

    public void changeId(String newId) {
        this.id = newId;
    }

    public void addNode(TreeNode<T, M> node) {
        this.children.put(node.id, node);
        node.parent = this;
        super.constructNodePath();
    }

    public void removeNode(String id) {
        if (this.children.containsKey(id)) {
            TreeNode<T, M> child = this.children.get(id);
            child.parent = null;
            super.constructNodePath();
            this.children.remove(id);
        }
    }

    public Collection<TreeNode<T, M>> getNodes() {
        return this.children.values();
    }

    public boolean hasNode(String id) {
        return this.children.containsKey(id);
    }

    public TreeNode<T, M> getNode(String id) throws TreeException {
        if (!this.children.containsKey(id)) {
            throw new TreeException("Tree node with id " + id + " is unavailable.");
        }
        return this.children.get(id);
    }

    public T getNodeElement() {
        return this.nodeElement;
    }

    public M getDecorationElement() {
        return this.metaElement;
    }

    public TreeNode<T, M> getNodeFromPath(Path path) throws TreeException {
        return this.getNodeFromPath(path, 0);
    }

    private TreeNode<T, M> getNodeFromPath(Path path, int depth) throws TreeException {
        if (path == null) {
            throw new TreeException("Path is null.");
        }
        if (depth >= path.getSize()) {
            return this;
        }
        TreeNode<T, M> nextNode = this.getNode(path.getElementAt(depth));
        return super.getNodeFromPath(path, ++depth);
    }

    public TreeNode<T, M> getNodeFromAbsolutePath(Path path) throws TreeException {
        TreeNode<T, M> root = this.getRoot();
        return root.getNodeFromPath(path);
    }

    public Path getNodePath() {
        if (this.nodePath == null) {
            this.constructNodePath();
        }
        return this.nodePath;
    }

    private void propagateNodePathDown(ConstructiblePath nodePath) {
        ConstructiblePath newPath = new ConstructiblePath(nodePath);
        newPath.addLastElementToThis(this.id);
        this.nodePath = newPath;
        for (TreeNode<T, M> child : this.getNodes()) {
            super.propagateNodePathDown(newPath);
        }
    }

    private void constructNodePath() {
        ConstructiblePath path = new ConstructiblePath();
        this.constructNodePath(path);
        this.nodePath = path;
        for (TreeNode<T, M> child : this.getNodes()) {
            super.propagateNodePathDown(path);
        }
    }

    private void constructNodePath(ConstructiblePath path) {
        if (this.isRoot()) {
            return;
        }
        path.addFirstElementToThis(this.id);
        super.constructNodePath(path);
    }

    public TreeNode<T, M> getParent() {
        return this.parent;
    }

    public TreeNode<T, M> getRoot() {
        if (this.isRoot()) {
            return this;
        }
        return this.getParent().getRoot();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public String toString() {
        return "TreeNode [id=" + this.id + ", nodeElement=" + this.nodeElement + ", metaElement=" + this.metaElement + ", parent=" + this.parent + ", children=" + this.children + ", nodePath=" + this.nodePath + "]";
    }
}

