/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.Pair;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Alignment;
import at.mrdevelopment.toolkit.text.CenterStrategy;
import at.mrdevelopment.toolkit.text.DrawLineStrategy;
import at.mrdevelopment.toolkit.text.JustifyStrategy;
import at.mrdevelopment.toolkit.text.LeftAlignStrategy;
import at.mrdevelopment.toolkit.text.RightAlignStrategy;
import at.mrdevelopment.toolkit.text.TextUtils;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class TextLine {
    private List<Word> words = new ArrayList<Word>();
    private static final DrawLineStrategy DEFAULT_DRAW_LINE = new LeftAlignStrategy();
    private DrawLineStrategy drawLine = DEFAULT_DRAW_LINE;
    private List<Pair<Rectangle, TextLine>> textLines = new ArrayList<Pair<Rectangle, TextLine>>();
    private boolean wrap = true;
    private boolean condenseFactorCalculated = false;
    private List<TextLine> linesToDraw;
    private List<Word> skippedWords = new ArrayList<Word>();

    public void addWord(Word word) {
        this.words.add(word);
    }

    protected void setAlignment(Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                this.drawLine = new LeftAlignStrategy();
                break;
            }
            case RIGHT: {
                this.drawLine = new RightAlignStrategy();
                break;
            }
            case CENTER: {
                this.drawLine = new CenterStrategy();
                break;
            }
            case JUSTIFY: {
                this.drawLine = new JustifyStrategy();
                break;
            }
            default: {
                this.drawLine = DEFAULT_DRAW_LINE;
            }
        }
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public int getLargestAscent(Graphics2D graphics) throws OptionException {
        int ascent = 0;
        int height = 0;
        for (Word word : this.words) {
            int wordHeight = word.getHeight(graphics);
            if (word.isEmpty() || wordHeight <= height) continue;
            ascent = word.getAscent(graphics);
            height = wordHeight;
        }
        return ascent;
    }

    public int getLeading(Graphics2D graphics) throws OptionException {
        int leading = 0;
        for (int index = 0; index < this.words.size(); ++index) {
            Word word = this.words.get(index);
            if (index == 0) {
                leading = word.getLeading(graphics);
            }
            leading = Math.max(word.getLeading(graphics), leading);
        }
        return leading;
    }

    public int getLineHeight(Graphics2D graphics) throws OptionException {
        int height = 0;
        for (Word word : this.words) {
            height = Math.max(word.getHeight(graphics), height);
        }
        return height;
    }

    public int getLineHeight(Graphics2D graphics, int maxWidth) throws OptionException {
        int height = 0;
        List<TextLine> lines = this.wrap(graphics, maxWidth);
        for (TextLine line : lines) {
            height += line.getLineHeight(graphics);
        }
        return height;
    }

    public List<Word> getAllWords() {
        return this.words;
    }

    public List<Word> getNonEmptyWords() {
        ArrayList<Word> nonEmptyWords = new ArrayList<Word>();
        for (Word word : this.words) {
            if (word.isDelimiter() || word.isEmpty()) continue;
            nonEmptyWords.add(word);
        }
        return nonEmptyWords;
    }

    public boolean isFirstInLine(Word word) {
        if (word == null || this.words.isEmpty()) {
            return false;
        }
        return word == this.words.get(0);
    }

    public Rectangle draw(Graphics2D graphics, int xPos, int yPos, int maxWidth, int maxHeight) throws OptionException {
        return this.layout(graphics, xPos, yPos, maxWidth, maxHeight, true);
    }

    public Rectangle getBounds(Graphics2D graphics, int xPos, int yPos, int maxWidth, int maxHeight) throws IndexOutOfBoundsException, OptionException {
        return this.layout(graphics, xPos, yPos, maxWidth, maxHeight, false);
    }

    private Rectangle layout(Graphics2D graphics, int xPos, int yPos, int maxWidth, int maxHeight, boolean draw) throws IndexOutOfBoundsException, OptionException {
        if (!this.condenseFactorCalculated) {
            this.linesToDraw = this.calculateCondenseFactor(graphics, xPos, yPos, maxWidth, maxHeight);
        }
        Rectangle contentBounds = null;
        this.textLines.clear();
        int y = yPos;
        for (int index = 0; index < this.linesToDraw.size(); ++index) {
            Rectangle currentBounds;
            TextLine line = this.linesToDraw.get(index);
            int effectiveXPos = xPos;
            if (index > 0 && line.getAllWords().size() > 0) {
                effectiveXPos += line.getAllWords().get(0).getXOffsetForMultipleLines(graphics);
            }
            if (draw) {
                currentBounds = this.drawLine.draw(line, graphics, effectiveXPos, y, maxWidth);
                this.textLines.add(new Pair<Rectangle, TextLine>(currentBounds, line));
                currentBounds = this.handleNewLineWord(currentBounds);
                if (contentBounds == null) {
                    contentBounds = new Rectangle(currentBounds);
                } else {
                    contentBounds.add(currentBounds);
                }
                y += line.getLineHeight(graphics);
                continue;
            }
            currentBounds = this.drawLine.getBounds(line, graphics, effectiveXPos, y, maxWidth);
            this.textLines.add(new Pair<Rectangle, TextLine>(currentBounds, line));
            currentBounds = this.handleNewLineWord(currentBounds);
            if (contentBounds == null) {
                contentBounds = new Rectangle(currentBounds);
            } else {
                contentBounds.add(currentBounds);
            }
            y += line.getLineHeight(graphics);
        }
        return contentBounds;
    }

    private Rectangle handleNewLineWord(Rectangle currentBounds) {
        if (this.words.size() == 1 && this.words.get(0).isNewline()) {
            ++currentBounds.width;
        }
        return currentBounds;
    }

    private List<TextLine> calculateCondenseFactor(Graphics2D graphics, int xPos, int yPos, int maxWidth, int maxHeight) throws IndexOutOfBoundsException, OptionException {
        List<TextLine> lines = new ArrayList<TextLine>();
        this.skippedWords.clear();
        if (!this.words.isEmpty()) {
            for (Word word : this.words) {
                word.resetCondensed();
            }
            int contentWidth = TextUtils.getContentWidth(this.words, graphics, 0, this.words.size() - 1);
            int contentHeight = this.getLineHeight(graphics);
            if (contentWidth + xPos > maxWidth || contentHeight + yPos > maxHeight || this.isMinimumFontSizeSet()) {
                int lineWidth;
                lines = this.wrap(graphics, maxWidth);
                int lineCount = lines.size();
                List<Object> condensedLines = new ArrayList();
                int condenseIndex = 0;
                int fontSizeIndex = 0;
                int currentCondenseIndex = 0;
                int currentFontSizeIndex = 0;
                int lineHeight = this.getLinesHeight(graphics, lines);
                int originalWidth = lineWidth = this.getWidth(graphics, lines);
                int originalHeight = lineHeight;
                if (this.isIgnoreIfNotDrawnCorrect() && lineCount > 1 || lineHeight + yPos > maxHeight || lineWidth + xPos > maxWidth) {
                    boolean currentCondenseRemaining = false;
                    boolean lineCountChanged = true;
                    while (condensedLines.size() == 0 || lineCountChanged && currentCondenseRemaining || currentCondenseRemaining) {
                        currentCondenseRemaining = false;
                        for (Word word : this.words) {
                            currentCondenseRemaining = word.hasCondenseStepsRemaining() ? true : currentCondenseRemaining;
                            if (!currentCondenseRemaining) continue;
                            word.nextCondenseFactor();
                        }
                        if (currentCondenseRemaining) {
                            ++currentCondenseIndex;
                        }
                        if (!currentCondenseRemaining) {
                            for (Word word : this.words) {
                                currentCondenseRemaining = word.hasFontSizesRemaining() ? true : currentCondenseRemaining;
                            }
                            if (currentCondenseRemaining) {
                                ++currentFontSizeIndex;
                                currentCondenseIndex = 0;
                                for (Word word : this.words) {
                                    word.nextFontSize();
                                    word.resetCondensed();
                                }
                            }
                        }
                        List<TextLine> currentCondensedLines = this.wrap(graphics, maxWidth);
                        int currentLineHeight = this.getLinesHeight(graphics, currentCondensedLines);
                        int currentLineWidth = this.getWidth(graphics, currentCondensedLines);
                        if (condensedLines.size() == 0 || condensedLines.size() > 1 && currentCondensedLines.size() < condensedLines.size() && this.isIgnoreIfNotDrawnCorrect() || lineHeight + yPos > maxHeight && currentLineHeight < lineHeight || lineWidth + xPos > maxWidth && currentLineWidth < lineWidth) {
                            fontSizeIndex = currentFontSizeIndex;
                            condenseIndex = currentCondenseIndex;
                            condensedLines = currentCondensedLines;
                            lineHeight = currentLineHeight;
                            lineWidth = currentLineWidth;
                        }
                        boolean bl = lineCountChanged = currentCondensedLines.size() != lineCount;
                        if (condensedLines.size() != 1 || lineHeight + xPos >= maxHeight || lineWidth + yPos >= maxWidth) continue;
                        currentCondenseRemaining = false;
                        lineCountChanged = false;
                    }
                    if (this.isIgnoreIfNotDrawnCorrect() && condensedLines.size() < lines.size() || originalWidth + xPos > maxWidth && lineWidth < originalWidth || originalHeight + yPos > maxHeight && lineHeight < originalHeight) {
                        lines = condensedLines;
                        for (Word word : this.words) {
                            word.setCondenseFactor(condenseIndex);
                            word.setFontSizeIndex(fontSizeIndex);
                        }
                    } else {
                        for (Word word : this.words) {
                            word.resetCondensed();
                            word.resetFontSize();
                        }
                    }
                }
            } else {
                lines.add(this);
            }
        }
        this.condenseFactorCalculated = true;
        if (this.isFloat()) {
            lines = this.recalculateLines(lines, graphics, xPos, yPos, maxWidth, maxHeight);
        }
        return lines;
    }

    private int getWidth(Graphics2D graphics, List<TextLine> lines) throws IndexOutOfBoundsException, OptionException {
        int width = 0;
        for (TextLine line : lines) {
            width = Math.max(width, TextUtils.getContentWidth(line.getAllWords(), graphics));
        }
        return width;
    }

    private int getLinesHeight(Graphics2D graphics, List<TextLine> lines) throws OptionException {
        int height = 0;
        for (TextLine line : lines) {
            height += line.getLineHeight(graphics);
        }
        return height;
    }

    private List<TextLine> recalculateLines(List<TextLine> linesToDraw, Graphics2D graphics, int xPos, int yPos, int maxWidth, int maxHeight) throws IndexOutOfBoundsException, OptionException {
        int height = 0;
        Word word = null;
        for (int index = 0; index < linesToDraw.size(); ++index) {
            TextLine line = linesToDraw.get(index);
            if ((height += line.getLineHeight(graphics)) <= maxHeight) continue;
            word = line.getAllWords().get(0);
            break;
        }
        if (word != null) {
            int wordIndex = this.words.indexOf(word);
            int bulletIndex = -1;
            for (int index = wordIndex; index >= 0; --index) {
                if (!this.words.get(index).isBullet()) continue;
                for (bulletIndex = index; bulletIndex >= 0 && this.words.get(bulletIndex).isBullet(); --bulletIndex) {
                }
                break;
            }
            if (bulletIndex >= 0) {
                this.removeWords(bulletIndex, this.words.size());
            }
        }
        return this.wrap(graphics, maxWidth);
    }

    private void removeWords(int from, int to) {
        List<Word> subList = this.words.subList(from, to);
        ArrayList<Word> subListCopy = new ArrayList<Word>(subList);
        for (Word word : subListCopy) {
            this.skippedWords.add(word);
            this.words.remove(word);
        }
    }

    public List<Pair<Rectangle, TextLine>> getLinesToDraw() {
        return this.textLines;
    }

    private List<TextLine> wrap(Graphics2D graphics, int maxWidth) throws IndexOutOfBoundsException, OptionException {
        ArrayList<TextLine> textLines = new ArrayList<TextLine>();
        if (!this.isWrap()) {
            textLines.add(this);
            return textLines;
        }
        int start = 0;
        int end = 0;
        TextLine currentTextLine = new TextLine();
        while (end < this.getAllWords().size()) {
            int width = 0;
            width = this.isFloat() ? this.getWidthFromFloatingTextLine(graphics, start, end) : TextUtils.getContentWidth(this.words, graphics, start, end);
            if (textLines.size() > 0 && currentTextLine.getAllWords().size() > 0) {
                width += currentTextLine.getAllWords().get(0).getXOffsetForMultipleLines(graphics);
            }
            if (width > maxWidth) {
                if (!currentTextLine.isEmpty()) {
                    if (currentTextLine.getAllWords().get(currentTextLine.getAllWords().size() - 1).getText().equals(" ")) {
                        currentTextLine.getAllWords().remove(currentTextLine.getAllWords().size() - 1);
                    }
                    textLines.add(currentTextLine);
                }
                currentTextLine = new TextLine();
                start = end;
                if (this.getAllWords().get(end).getText().equals(" ")) {
                    ++end;
                    continue;
                }
            }
            if (!this.getAllWords().get(end).isEmpty()) {
                currentTextLine.addWord(this.getAllWords().get(end));
            }
            ++end;
        }
        if (!currentTextLine.getText().equals(" ") && !currentTextLine.isEmpty() || textLines.size() == 0) {
            textLines.add(currentTextLine);
        }
        this.applyWrappedLineSpace(textLines);
        return textLines;
    }

    private int getWidthFromFloatingTextLine(Graphics2D graphics, int start, int end) throws IndexOutOfBoundsException, OptionException {
        if (!this.getAllWords().get(end).isBullet()) {
            return TextUtils.getContentWidth(this.words, graphics, start, end);
        }
        int bulletEnd = 0;
        while (end + bulletEnd < this.getAllWords().size() - 1 && this.getAllWords().get(end + bulletEnd).isBullet()) {
            ++bulletEnd;
        }
        return TextUtils.getContentWidth(this.words, graphics, start, end + bulletEnd);
    }

    private void applyWrappedLineSpace(List<TextLine> textLines) throws OptionException {
        if (textLines.size() > 1) {
            for (int lineIndex = 0; lineIndex < textLines.size() - 1; ++lineIndex) {
                for (Word word : textLines.get(lineIndex).getAllWords()) {
                    word.applyWrappedLineSpace();
                }
            }
        }
    }

    private boolean isEmpty() {
        return this.getText().isEmpty();
    }

    public boolean isIgnoreIfNotDrawnCorrect() {
        for (Word word : this.getAllWords()) {
            if (!word.isIgnoreIfDrawnIncomplete()) continue;
            return true;
        }
        return false;
    }

    public boolean isFloat() {
        for (Word word : this.getAllWords()) {
            if (!word.isFloat()) continue;
            return true;
        }
        return false;
    }

    public boolean isCondenseEnabled() throws OptionException {
        for (Word word : this.getAllWords()) {
            if (!word.isCondenseEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isMinimumFontSizeSet() {
        for (Word word : this.getAllWords()) {
            if (!word.isMinimumFontSizeSet()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TextLine: [");
        for (int i = 0; i < this.words.size(); ++i) {
            builder.append(this.words.get(i).toString());
        }
        builder.append("]");
        return builder.toString();
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.words.size(); ++i) {
            builder.append(this.words.get(i).getText());
        }
        return builder.toString();
    }

    public boolean hasSkippedWords() {
        return this.skippedWords.size() > 0;
    }

    public List<Word> getSkippedWords() {
        return this.skippedWords;
    }
}

