/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.image.Padding;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.OptionProvider;
import at.mrdevelopment.toolkit.text.FontSizeContainer;
import at.mrdevelopment.toolkit.text.SuperScript;
import at.mrdevelopment.toolkit.text.TextOptionContainer;
import at.mrdevelopment.toolkit.text.TextOptionContainerImpl;
import at.mrdevelopment.toolkit.text.TextUtils;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TextElement
extends Element
implements OptionProvider<TextOptionContainer> {
    protected TextElement parent = null;
    protected TextOptionContainerImpl optionContainer = new TextOptionContainerImpl();
    protected int currentFontSizeIndex = 0;
    protected int currentCondenseFactorIndex = 0;
    private int fixedCondenseFactorIndex = 0;
    private int fontStyleInt;
    private int fontWeightInt;
    private String fontFamily;
    private int minimumFontSizeIndex = 0;
    private boolean useWrappedLineSpacing = false;
    protected FontSizeContainer fontSizeContainer;

    public TextElement(Map<String, Option<?>> options, Class<? extends Element> elementClass) throws OptionException {
        super(options, elementClass);
        this.registerOptions(options);
        this.initFontOptions();
        this.initFontSizeContainer();
    }

    private void initFontSizeContainer() {
        this.fontSizeContainer = new FontSizeContainer();
    }

    public TextElement(Class<? extends Element> elementClass) throws OptionException {
        this(null, elementClass);
        this.initFontOptions();
        this.initFontSizeContainer();
    }

    public TextElement(Map<String, Option<?>> options, boolean ignoreAttributes) throws OptionException {
        super(options, ignoreAttributes);
        this.registerOptions(options);
        if (this.containsFontOptions(options)) {
            this.initFontOptions();
        }
        this.initFontSizeContainer();
    }

    private boolean containsFontOptions(Map<String, Option<?>> options) {
        return options.containsKey(Attribute.FONT_FAMILY.getKey()) && options.containsKey(Attribute.FONT_STYLE.getKey()) && options.containsKey(Attribute.FONT_WEIGHT.getKey()) && options.containsKey(Attribute.FONT_SIZE.getKey());
    }

    private boolean containsFont(String fontFamily) {
        return TextUtils.isFontAvailable(fontFamily);
    }

    private void initFontOptions() throws OptionException {
        this.fontFamily = this.optionContainer.getStringOptionValue(Attribute.FONT_FAMILY.getKey());
        if (!this.containsFont(this.fontFamily)) {
            throw new OptionException(String.format("No font with the name %s available", this.fontFamily));
        }
        FontStyle fontStyle = this.optionContainer.getFontStyleOptionValue(Attribute.FONT_STYLE.getKey());
        FontWeight fontWeight = this.optionContainer.getFontWeightOptionValue(Attribute.FONT_WEIGHT.getKey());
        this.fontStyleInt = 0;
        switch (fontStyle) {
            case NORMAL: {
                this.fontStyleInt = 0;
                break;
            }
            case ITALIC: {
                this.fontStyleInt = 2;
                break;
            }
            default: {
                this.fontStyleInt = 0;
            }
        }
        this.fontWeightInt = 0;
        switch (fontWeight) {
            case NORMAL: {
                this.fontWeightInt = 0;
                break;
            }
            case BOLD: {
                this.fontWeightInt = 1;
                break;
            }
            default: {
                this.fontWeightInt = 0;
            }
        }
    }

    private void registerOptions(Map<String, Option<?>> options) throws OptionException {
        if (options != null) {
            this.registerTextOptions(options.values());
        } else {
            this.registerTextOptions();
        }
    }

    protected void registerTextOptions(Collection<Option<?>> options) throws OptionException {
        for (Option<?> option : options) {
            this.optionContainer.registerOption(option);
        }
    }

    protected void registerTextOptions() throws OptionException {
        for (Attribute attribute : this.getAttributes()) {
            try {
                this.optionContainer.registerOption(attribute.createOption());
            }
            catch (Exception exc) {
                throw new OptionException(exc);
            }
        }
    }

    public int getHeight(Graphics2D graphics) throws OptionException {
        if (!this.fontSizeContainer.containsHeight(this.currentFontSizeIndex, this.currentCondenseFactorIndex)) {
            this.preloadValues(graphics);
        }
        return this.fontSizeContainer.getHeight(this.currentFontSizeIndex, this.currentCondenseFactorIndex) + this.getLineSpacing();
    }

    public int getAscent(Graphics2D graphics) throws OptionException {
        if (!this.fontSizeContainer.containsAscent(this.currentFontSizeIndex, this.currentCondenseFactorIndex)) {
            this.preloadValues(graphics);
        }
        return this.fontSizeContainer.getAscent(this.currentFontSizeIndex, this.currentCondenseFactorIndex);
    }

    private void preloadValues(Graphics2D graphics) throws OptionException {
        if (!this.getUnicodeUpdatedText().isEmpty()) {
            try {
                TextLayout textLayout = new TextLayout(this.getUnicodeUpdatedText(), this.getFont(), graphics.getFontRenderContext());
                this.fontSizeContainer.storeAscent(this.currentFontSizeIndex, this.currentCondenseFactorIndex, Math.round(textLayout.getAscent()));
                this.fontSizeContainer.storeDescent(this.currentFontSizeIndex, this.currentCondenseFactorIndex, Math.round(textLayout.getDescent()));
                this.fontSizeContainer.storeHeight(this.currentFontSizeIndex, this.currentCondenseFactorIndex, Math.round(textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading()));
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                LineMetrics lineMetrics = graphics.getFontMetrics(this.getFont()).getLineMetrics(this.getUnicodeUpdatedText(), graphics);
                this.fontSizeContainer.storeAscent(this.currentFontSizeIndex, this.currentCondenseFactorIndex, Math.round(lineMetrics.getAscent()));
                this.fontSizeContainer.storeDescent(this.currentFontSizeIndex, this.currentCondenseFactorIndex, Math.round(lineMetrics.getDescent()));
                this.fontSizeContainer.storeHeight(this.currentFontSizeIndex, this.currentCondenseFactorIndex, Math.round(lineMetrics.getAscent() + lineMetrics.getDescent() + lineMetrics.getLeading()));
            }
        } else {
            this.fontSizeContainer.storeAscent(this.currentFontSizeIndex, this.currentCondenseFactorIndex, 0);
            this.fontSizeContainer.storeDescent(this.currentFontSizeIndex, this.currentCondenseFactorIndex, 0);
            this.fontSizeContainer.storeHeight(this.currentFontSizeIndex, this.currentCondenseFactorIndex, 0);
        }
        this.graphicsObjectChanged(graphics);
    }

    protected abstract void graphicsObjectChanged(Graphics2D var1) throws OptionException;

    protected int getDescent(Graphics2D graphics) throws OptionException {
        if (!this.fontSizeContainer.containsDescent(this.currentFontSizeIndex, this.currentCondenseFactorIndex)) {
            this.preloadValues(graphics);
        }
        this.preloadValues(graphics);
        return this.fontSizeContainer.getDescent(this.currentFontSizeIndex, this.currentCondenseFactorIndex) + this.getLineSpacing();
    }

    protected int getLeading(Graphics2D graphics) throws OptionException {
        return this.getLineSpacing();
    }

    protected int getLineSpacing() throws OptionException {
        return this.useWrappedLineSpacing ? this.optionContainer.getIntegerOptionValue(Attribute.WRAPPED_LINE_SPACING.getKey()) : this.optionContainer.getIntegerOptionValue(Attribute.LINE_SPACING.getKey());
    }

    public void applyWrappedLineSpace() throws OptionException {
        if (this.optionContainer.hasOption(Attribute.WRAPPED_LINE_SPACING.getKey())) {
            this.useWrappedLineSpacing = true;
        }
    }

    protected TextElement getParent() {
        return this.parent;
    }

    protected void setParent(TextElement parent) {
        this.parent = parent;
    }

    protected TextElement getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    protected List<TextElement> getPathToRoot() {
        ArrayList<TextElement> path = new ArrayList<TextElement>();
        if (this.getParent() != null) {
            path.addAll(this.getParent().getPathToRoot());
        }
        path.add(this);
        return path;
    }

    protected TextElement getTopElementWithOptionSet(String optionKey) throws OptionException {
        TextElement parentWithOption;
        if (this.parent != null && (parentWithOption = this.parent.getTopElementWithOptionSet(optionKey)) != null) {
            return parentWithOption;
        }
        if (this.optionContainer.comparePriorities(this.optionContainer.getOption(optionKey).getSource(), Option.Source.NONE) == 1) {
            return this;
        }
        return null;
    }

    protected Padding getPadding() throws OptionException {
        int top = this.optionContainer.getIntegerOptionValue(Attribute.PADDING_TOP.getKey());
        int right = this.optionContainer.getIntegerOptionValue(Attribute.PADDING_RIGHT.getKey());
        int bottom = this.optionContainer.getIntegerOptionValue(Attribute.PADDING_BOTTOM.getKey());
        int left = this.optionContainer.getIntegerOptionValue(Attribute.PADDING_LEFT.getKey());
        return new Padding(top, right, bottom, left);
    }

    protected Font getFont() throws OptionException {
        TextDecoration textDecoration;
        SuperScript superScript;
        int fontSize = this.getFontSize();
        Font font = new Font(this.fontFamily, this.fontWeightInt + this.fontStyleInt, fontSize);
        HashMap<TextAttribute, Serializable> attributes = new HashMap<TextAttribute, Serializable>();
        if (this.getLetterSpacing() != 0.0) {
            attributes.put(TextAttribute.TRACKING, Double.valueOf(this.getLetterSpacing()));
        }
        if (!(superScript = this.getSuperScript()).equals((Object)SuperScript.NORMAL)) {
            attributes.put(TextAttribute.SUPERSCRIPT, superScript.equals((Object)SuperScript.SUPERSCRIPT) ? TextAttribute.SUPERSCRIPT_SUPER : TextAttribute.SUPERSCRIPT_SUB);
        }
        if ((textDecoration = this.getTextDecoration()) == TextDecoration.LINETHROUGH) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        } else if (textDecoration == TextDecoration.UNDERLINE) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (attributes.size() > 0) {
            font = font.deriveFont(attributes);
        }
        return this.isCondenseEnabled() ? this.applyCondensing(font) : font;
    }

    public double getLetterSpacing() throws OptionException {
        return this.optionContainer.getDoubleOptionValue(Attribute.LETTER_SPACING.getKey());
    }

    public SuperScript getSuperScript() throws OptionException {
        return (SuperScript)this.optionContainer.getEnumOptionValue(Attribute.SUPERSCRIPT.getKey());
    }

    public boolean isCondenseEnabled() throws OptionException {
        return !this.optionContainer.getDoubleArrayOptionValue(Attribute.CONDENSE_FACTOR.getKey())[this.currentCondenseFactorIndex].equals(new Double(1.0));
    }

    public boolean hasCondenseStepsRemaining() throws OptionException {
        return this.currentCondenseFactorIndex < this.optionContainer.getDoubleArrayOptionValue(Attribute.CONDENSE_FACTOR.getKey()).length - 1;
    }

    private Font applyCondensing(Font font) throws OptionException {
        return font.deriveFont(this.getCondensingTransformation());
    }

    private AffineTransform getCondensingTransformation() throws OptionException {
        return new AffineTransform(this.getCondenseFactor(), 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    private double getCondenseFactor() throws OptionException {
        return (Double)this.optionContainer.getDoubleArrayOptionValue(Attribute.CONDENSE_FACTOR.getKey())[this.currentCondenseFactorIndex];
    }

    protected int getFontSize() throws OptionException {
        return (Integer)this.optionContainer.getIntegerArrayOptionValue(Attribute.FONT_SIZE.getKey())[this.currentFontSizeIndex];
    }

    public boolean nextMinimumFontSize() throws OptionException {
        Object[] fontSizes = this.optionContainer.getIntegerArrayOptionValue(Attribute.FONT_SIZE.getKey());
        if (this.minimumFontSizeIndex < this.currentFontSizeIndex) {
            this.minimumFontSizeIndex = this.currentFontSizeIndex;
        }
        if (this.minimumFontSizeIndex < fontSizes.length - 1) {
            ++this.minimumFontSizeIndex;
            if (this.currentFontSizeIndex < this.minimumFontSizeIndex) {
                this.currentFontSizeIndex = this.minimumFontSizeIndex;
            }
            return true;
        }
        return false;
    }

    public boolean nextFontSize() throws OptionException {
        Object[] fontSizes = this.optionContainer.getIntegerArrayOptionValue(Attribute.FONT_SIZE.getKey());
        if (this.currentFontSizeIndex < this.minimumFontSizeIndex) {
            this.currentFontSizeIndex = this.minimumFontSizeIndex;
        }
        if (this.currentFontSizeIndex < fontSizes.length - 1) {
            ++this.currentFontSizeIndex;
            return true;
        }
        return false;
    }

    public double nextCondenseFactor() throws OptionException {
        Object[] condenseFactors = this.optionContainer.getDoubleArrayOptionValue(Attribute.CONDENSE_FACTOR.getKey());
        if (this.currentCondenseFactorIndex < condenseFactors.length - 1) {
            ++this.currentCondenseFactorIndex;
            return (Double)condenseFactors[this.currentCondenseFactorIndex];
        }
        return 1.0;
    }

    public void setCondenseFactor(int condenseFactorIndex) throws OptionException {
        Object[] condenseFactors = this.optionContainer.getDoubleArrayOptionValue(Attribute.CONDENSE_FACTOR.getKey());
        if (condenseFactorIndex >= 0 && condenseFactorIndex < condenseFactors.length) {
            this.currentCondenseFactorIndex = condenseFactorIndex;
        }
    }

    public void setFixedCondenseFactor(int condenseFactorIndex) throws OptionException {
        Object[] condenseFactors = this.optionContainer.getDoubleArrayOptionValue(Attribute.CONDENSE_FACTOR.getKey());
        if (condenseFactorIndex >= 0 && condenseFactorIndex < condenseFactors.length) {
            this.fixedCondenseFactorIndex = condenseFactorIndex;
            if (this.currentCondenseFactorIndex < this.fixedCondenseFactorIndex) {
                this.currentCondenseFactorIndex = this.fixedCondenseFactorIndex;
            }
        }
    }

    public boolean hasFontSizesRemaining() throws OptionException {
        return this.currentFontSizeIndex < this.optionContainer.getIntegerArrayOptionValue(Attribute.FONT_SIZE.getKey()).length - 1;
    }

    public abstract List<Word> getLeaves();

    protected abstract void propagateOptions() throws OptionException;

    public abstract String getText();

    public String getUnicodeUpdatedText() throws OptionException {
        return TextUtils.updateUnicodeRange(this.getText(), this.getFont());
    }

    @Override
    public TextOptionContainer getOptionContainer() {
        return this.optionContainer;
    }

    public void resetCondensed() {
        this.currentCondenseFactorIndex = this.fixedCondenseFactorIndex;
    }

    public void resetFontSize() {
        this.currentFontSizeIndex = this.minimumFontSizeIndex;
    }

    public int getFontSizeIndex() {
        return this.currentFontSizeIndex;
    }

    public int getCondenseFactorIndex() {
        return this.currentCondenseFactorIndex;
    }

    public void setMinimumFontSizeIndex(int fontSizeIndex) throws OptionException {
        Object[] fontSizes = this.optionContainer.getIntegerArrayOptionValue(Attribute.FONT_SIZE.getKey());
        if (fontSizeIndex >= 0 && fontSizeIndex < fontSizes.length) {
            this.minimumFontSizeIndex = fontSizeIndex;
            if (this.currentFontSizeIndex < this.minimumFontSizeIndex) {
                this.currentFontSizeIndex = this.minimumFontSizeIndex;
            }
        }
    }

    public void setFontSizeIndex(int fontSizeIndex) throws OptionException {
        Object[] fontSizes = this.optionContainer.getIntegerArrayOptionValue(Attribute.FONT_SIZE.getKey());
        if (fontSizeIndex >= 0 && fontSizeIndex + this.minimumFontSizeIndex < fontSizes.length) {
            this.currentFontSizeIndex = fontSizeIndex + this.minimumFontSizeIndex;
        }
    }

    public boolean isMinimumFontSizeSet() {
        return this.minimumFontSizeIndex > 0;
    }

    public TextDecoration getTextDecoration() throws OptionException {
        return this.optionContainer.getTextDecorationOptionValue(Attribute.TEXT_DECORATION.getKey());
    }

    public static enum TextDecoration {
        UNDERLINE,
        LINETHROUGH,
        NONE;

    }

    public static enum FontWeight {
        NORMAL,
        BOLD;

    }

    public static enum FontStyle {
        NORMAL,
        ITALIC;

    }
}

