/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.Pair;
import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Alignment;
import at.mrdevelopment.toolkit.text.RootSpan;
import at.mrdevelopment.toolkit.text.TextImageException;
import at.mrdevelopment.toolkit.text.TextLine;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpanImage {
    private static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    protected BufferedImage image;
    private ExecutionStatus executionStatus;
    protected Graphics2D graphics;
    protected RootSpan span;
    protected Rectangle contentBounds = new Rectangle();
    protected Alignment alignment = Alignment.LEFT;
    private Map<Integer, String> skippedLines;
    private int lineCount = 0;
    private int widthBeforeReset;
    private boolean multipleLines;
    private Rectangle alignmentBounds;
    private final boolean verbose;
    private boolean successful = true;
    private Set<Word> wrappedLineWords = new HashSet<Word>();

    public SpanImage(RootSpan span, int width, int height, Alignment alignment, boolean verbose) {
        this.span = span;
        this.alignment = alignment;
        this.verbose = verbose;
        this.executionStatus = new ExecutionStatus();
        this.skippedLines = new HashMap<Integer, String>();
        try {
            this.render(width, height);
        }
        catch (OptionException e) {
            if (verbose) {
                this.executionStatus.addElement(new ExceptionElement(e));
            }
            this.successful = false;
            this.image = ImageUtils.createImage(width, height, 2);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public Rectangle getContentBounds() {
        return this.contentBounds;
    }

    protected void initCanvas(int width, int height) {
        this.image = new BufferedImage(width, height, 2);
        this.graphics = this.image.createGraphics();
        this.graphics.setBackground(TRANSPARENT);
        this.graphics.setColor(Color.BLACK);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.graphics.clearRect(0, 0, width, height);
    }

    protected void render(int width, int height) throws OptionException {
        this.initCanvas(width, height);
        this.span.propagateOptions();
        int xPos = 0;
        int yPos = 0;
        List<TextLine> textLines = this.generateTextLines();
        if (this.span.getPadding().getLeft() != 0) {
            Rectangle leftPadding = new Rectangle(0, 0, this.span.getPadding().getLeft(), 0);
            xPos += this.span.getPadding().getLeft();
            this.addToContentBounds(leftPadding);
        }
        if (this.span.getPadding().getTop() != 0) {
            Rectangle topPadding = new Rectangle(0, 0, 0, this.span.getPadding().getTop());
            yPos += this.span.getPadding().getTop();
            this.addToContentBounds(topPadding);
        }
        for (int index = 0; index < textLines.size(); ++index) {
            int newYPos = this.renderTextElement(index, width, height, xPos, yPos, width - this.span.getPadding().getLeft() - this.span.getPadding().getRight(), height - this.span.getPadding().getTop() - this.span.getPadding().getBottom(), textLines.get(index));
            if (newYPos != yPos) {
                yPos = newYPos;
                if (index == textLines.size() - 1 && textLines.get(index).getNonEmptyWords().size() > 0) {
                    this.alignmentBounds = new Rectangle(this.contentBounds);
                    this.alignmentBounds.height -= textLines.get(index).getLeading(this.graphics);
                    this.contentBounds.height -= textLines.get(index).getLeading(this.graphics);
                }
            }
            this.handleNewLineWithListElement(textLines, index);
        }
        if (this.span.getPadding().getBottom() != 0) {
            this.contentBounds.height += this.span.getPadding().getBottom();
        }
        if (this.span.getPadding().getRight() != 0) {
            Rectangle rightPadding = new Rectangle(this.contentBounds.width - 1, 0, this.span.getPadding().getRight(), this.contentBounds.height);
            this.addToContentBounds(rightPadding);
        }
        if (this.contentBounds != null) {
            this.contentBounds.y = this.contentBounds.y < 0 ? 0 : this.contentBounds.y;
            int n = this.contentBounds.x = this.contentBounds.x < 0 ? 0 : this.contentBounds.x;
        }
        if (this.alignmentBounds != null) {
            this.alignmentBounds.y = this.alignmentBounds.y < 0 ? 0 : this.alignmentBounds.y;
            this.alignmentBounds.x = this.alignmentBounds.x < 0 ? 0 : this.alignmentBounds.x;
        }
        this.image = SpanImage.clipIfNecessary(this.image, this.contentBounds, width, height, this.verbose ? this.executionStatus : null);
    }

    private void handleNewLineWithListElement(List<TextLine> textLines, int index) throws OptionException {
        if (index < textLines.size() - 1) {
            TextLine currentLine = textLines.get(index);
            TextLine nextLine = textLines.get(index + 1);
            if (currentLine.isIgnoreIfNotDrawnCorrect() && !currentLine.isFloat() && currentLine.getAllWords().size() > 1 && currentLine.getAllWords().get(1).isBullet() && nextLine.getAllWords().size() > 1 && !nextLine.getAllWords().get(1).isBullet()) {
                int condenseIndex = currentLine.getAllWords().get(currentLine.getAllWords().size() - 1).getCondenseFactorIndex();
                int fontSizeIndex = currentLine.getAllWords().get(currentLine.getAllWords().size() - 1).getFontSizeIndex();
                for (Word word : nextLine.getAllWords()) {
                    word.setMinimumFontSizeIndex(fontSizeIndex);
                    word.setFixedCondenseFactor(condenseIndex);
                }
            }
        }
    }

    public static BufferedImage clipIfNecessary(BufferedImage image, Rectangle contentBounds, int maxWidth, int maxHeight, ExecutionStatus status) {
        if (contentBounds != null) {
            if (contentBounds.height > maxHeight && status != null) {
                status.addElement(new ExceptionElement(new TextImageException("Text is higher than allowed. Effective height = " + contentBounds.height + ", " + "Max height = " + maxHeight)));
            }
            if (contentBounds.width > maxWidth && status != null) {
                status.addElement(new ExceptionElement(new TextImageException("Text is wider than allowed. Effective width = " + contentBounds.width + ", " + "Max width = " + maxWidth)));
            }
            if (image.getWidth() > 0 && image.getHeight() > 0 && maxWidth > 0 && maxHeight > 0 && contentBounds.width > 0 && contentBounds.height > 0) {
                image = ImageUtils.clipToUsedSize(image, contentBounds, maxWidth, maxHeight);
            }
        }
        return image;
    }

    private int renderTextElement(int index, int maxWidth, int maxHeight, int xPos, int yPos, int width, int height, TextLine line) throws OptionException {
        Rectangle currentBounds = line.getBounds(this.graphics, xPos, yPos, width, maxHeight);
        if (currentBounds != null && !currentBounds.isEmpty()) {
            boolean outOfSpace = this.isOutOfSpace(currentBounds, maxWidth, maxHeight);
            if (line.isFloat() && line.hasSkippedWords()) {
                StringBuilder builder = new StringBuilder();
                for (Word word : line.getSkippedWords()) {
                    word.setSkipped(true);
                    builder.append(word.getText());
                }
                this.skippedLines.put(this.lineCount + line.getLinesToDraw().size() + 1, builder.toString());
                this.successful = false;
            } else if (outOfSpace) {
                List<Integer> lineOutOfBounds = this.getOutOfBoundsLines(line, maxWidth, maxHeight);
                this.successful = false;
                for (Integer i : lineOutOfBounds) {
                    this.skippedLines.put(i + this.lineCount + 1, line.getLinesToDraw().get(i).getSecond().getText());
                    for (Word word : line.getLinesToDraw().get(i).getSecond().getAllWords()) {
                        word.setSkipped(true);
                    }
                }
                if (currentBounds.width > maxWidth) {
                    this.resetWidth(maxWidth);
                }
            }
            if (!outOfSpace || !line.isIgnoreIfNotDrawnCorrect()) {
                currentBounds = line.draw(this.graphics, xPos, yPos, width, maxHeight);
                this.addToContentBounds(currentBounds);
                yPos = index > 0 ? yPos + currentBounds.height : this.span.getPadding().getTop() + currentBounds.height;
            }
            boolean currentMultipleLines = line.getLinesToDraw().size() > 1;
            boolean bl = this.multipleLines = currentMultipleLines ? currentMultipleLines : this.multipleLines;
            if (currentMultipleLines) {
                this.wrappedLineWords.addAll(line.getAllWords());
            }
            this.lineCount += line.getLinesToDraw().size();
        }
        return yPos;
    }

    private List<Integer> getOutOfBoundsLines(TextLine line, int maxWidth, int maxHeight) {
        ArrayList<Integer> textLineIndices = new ArrayList<Integer>();
        List<Pair<Rectangle, TextLine>> lines = line.getLinesToDraw();
        Rectangle maxBounds = new Rectangle(maxWidth, maxHeight);
        for (int index = 0; index < lines.size(); ++index) {
            Rectangle bounds = lines.get(index).getFirst();
            if (maxBounds.contains(bounds)) continue;
            textLineIndices.add(index);
        }
        return textLineIndices;
    }

    private boolean isOutOfSpace(Rectangle currentBounds, int maxWidth, int maxHeight) {
        return currentBounds.x + currentBounds.width > maxWidth || currentBounds.y + currentBounds.height > maxHeight;
    }

    private void resetWidth(int maxWidth) {
        if (this.contentBounds != null && this.contentBounds.width > maxWidth) {
            this.widthBeforeReset = this.contentBounds.width;
            this.contentBounds.width = maxWidth;
        }
    }

    public boolean isWidthResetted() {
        return this.widthBeforeReset > 0;
    }

    public int getWidthBeforeReset() {
        return this.widthBeforeReset;
    }

    protected List<TextLine> generateTextLines() {
        ArrayList<TextLine> lines = new ArrayList<TextLine>();
        int currentLineIndex = -1;
        for (Word word : this.span.getLeaves()) {
            TextLine textLine;
            if (word.isNewline()) {
                textLine = new TextLine();
                textLine.setAlignment(this.alignment);
                textLine.addWord(word);
                lines.add(textLine);
                currentLineIndex = -1;
                continue;
            }
            if (currentLineIndex == -1) {
                textLine = new TextLine();
                textLine.setAlignment(this.alignment);
                if (lines.size() > 0) {
                    lines.set(lines.size() - 1, textLine);
                } else {
                    lines.add(textLine);
                }
                currentLineIndex = lines.size() - 1;
            }
            ((TextLine)lines.get(currentLineIndex)).addWord(word);
        }
        return lines;
    }

    protected void addToContentBounds(Rectangle rectangle) {
        if (this.contentBounds == null) {
            this.contentBounds = new Rectangle(rectangle);
        } else {
            this.contentBounds.add(rectangle);
        }
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public boolean hasSkippedLines() {
        return this.skippedLines.size() > 0;
    }

    public Map<Integer, String> getSkippedLines() {
        return this.skippedLines;
    }

    public boolean hasMultipleLines() {
        return this.multipleLines;
    }

    public Collection<Word> getMultipleLineWords() {
        return this.wrappedLineWords;
    }

    public Rectangle getAlignmentBounds() {
        return this.alignmentBounds;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

