/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.LineWrap;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@TemplateElementType(type=TemplateNode.SPAN)
public class Span
extends TextElement {
    protected List<TextElement> textElements = new ArrayList<TextElement>();
    private LineWrap lineWrap = LineWrap.NORMAL;

    public Span(Map<String, Option<?>> options) throws OptionException {
        super(options, Span.class);
        this.lineWrap = (LineWrap)((Object)options.get(Attribute.WRAP.getKey()).get());
    }

    public Span() throws OptionException {
        super(null, Span.class);
        this.lineWrap = LineWrap.NONE;
    }

    public Span(Class<? extends Element> elementClass) throws OptionException {
        super(null, elementClass);
    }

    public Span(Map<String, Option<?>> options, Class<? extends Element> elementClass) throws OptionException {
        super(options, elementClass);
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    public void addTextElement(TextElement textElement) throws OptionException {
        this.textElements.add(textElement);
        textElement.setParent(this);
    }

    @Override
    protected void propagateOptions() throws OptionException {
        for (TextElement textElement : this.textElements) {
            textElement.optionContainer.inherit(this.optionContainer);
            textElement.propagateOptions();
        }
    }

    protected boolean isFirstInSpan(TextElement textElement) {
        List<Word> leaves = this.getLeaves();
        if (leaves == null || leaves.isEmpty()) {
            return false;
        }
        return leaves.get(0) == textElement;
    }

    public List<TextElement> getTextElements() {
        return this.textElements;
    }

    @Override
    public List<Word> getLeaves() {
        ArrayList<Word> leaves = new ArrayList<Word>();
        for (TextElement textElement : this.textElements) {
            leaves.addAll(textElement.getLeaves());
        }
        return leaves;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (TextElement textElement : this.textElements) {
            builder.append(textElement.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (Word word : this.getLeaves()) {
            builder.append(word.getText());
        }
        return builder.toString();
    }

    @Override
    protected void graphicsObjectChanged(Graphics2D graphics) throws OptionException {
    }

    public LineWrap getLineWrap() {
        return this.lineWrap;
    }
}

