/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.DrawLineStrategy;
import at.mrdevelopment.toolkit.text.Span;
import at.mrdevelopment.toolkit.text.TextLine;
import at.mrdevelopment.toolkit.text.TextUtils;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class JustifyStrategy
extends DrawLineStrategy {
    @Override
    public Rectangle draw(TextLine textLine, Graphics2D graphics, int xPos, int yPos, int width) throws OptionException {
        return this.layout(textLine, graphics, xPos, yPos, width, true);
    }

    @Override
    public Rectangle getBounds(TextLine textLine, Graphics2D graphics, int xPos, int yPos, int width) throws OptionException {
        return this.layout(textLine, graphics, xPos, yPos, width, false);
    }

    private Rectangle layout(TextLine textLine, Graphics2D graphics, int xPos, int yPos, int maxWidth, boolean draw) throws OptionException {
        List<Word> nonEmptyWords = textLine.getNonEmptyWords();
        int spaceLeft = maxWidth - TextUtils.getContentWidth(nonEmptyWords, graphics);
        int glue = 0;
        if (nonEmptyWords.size() > 0) {
            glue = (int)Math.floor((float)spaceLeft / (float)(nonEmptyWords.size() - 1));
        }
        int largestAscent = textLine.getLargestAscent(graphics);
        Rectangle bounds = new Rectangle(new Point(xPos, yPos));
        for (Word word : textLine.getAllWords()) {
            Rectangle currentBounds;
            boolean nonEmpty = nonEmptyWords.contains(word);
            int xAfterWord = word.getWidth(graphics);
            int heightOffset = largestAscent - word.getAscent(graphics);
            if (draw) {
                this.applyCompoundStyle(word, textLine, graphics, xPos, yPos, maxWidth);
                if (nonEmpty) {
                    currentBounds = word.draw(graphics, xPos, yPos + heightOffset);
                    bounds.add(currentBounds);
                }
            } else {
                currentBounds = word.getBounds(graphics, xPos, yPos + heightOffset);
                bounds.add(currentBounds);
            }
            if (!nonEmpty) continue;
            xPos += xAfterWord + glue;
        }
        return bounds;
    }

    @Override
    protected Rectangle getSpanBoundsInLine(TextLine textLine, Span span, Word word, Graphics2D graphics, int xPos, int yPos, int maxWidth) throws OptionException {
        List<Word> nonEmptyWordsInLine = textLine.getNonEmptyWords();
        int spaceLeft = maxWidth - TextUtils.getContentWidth(nonEmptyWordsInLine, graphics);
        int glue = 0;
        if (nonEmptyWordsInLine.size() > 0) {
            glue = (int)Math.floor((float)spaceLeft / (float)(nonEmptyWordsInLine.size() - 1));
        }
        Rectangle bounds = null;
        List<Word> wordsInSpan = span.getLeaves();
        int largestAscent = textLine.getLargestAscent(graphics);
        for (Word spanWord : wordsInSpan) {
            if (!nonEmptyWordsInLine.contains(spanWord)) continue;
            int xAfterWord = spanWord.getWidth(graphics);
            int heightOffset = largestAscent - spanWord.getAscent(graphics);
            if (bounds == null) {
                bounds = spanWord.getBounds(graphics, xPos, yPos + heightOffset);
            } else {
                bounds.add(spanWord.getBounds(graphics, xPos, yPos + heightOffset));
            }
            xPos += xAfterWord + glue;
        }
        return bounds;
    }
}

