/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import java.util.HashMap;
import java.util.Map;

public class FontSizeContainer {
    private Map<FontAttribute, Map<String, Integer>> attributeMap = new HashMap<FontAttribute, Map<String, Integer>>();

    public FontSizeContainer() {
        for (FontAttribute attribute : FontAttribute.values()) {
            this.attributeMap.put(attribute, new HashMap());
        }
    }

    public void storeAscent(int fontSizeIndex, int condenseIndex, int ascent) {
        this.store(fontSizeIndex, condenseIndex, ascent, FontAttribute.ASCENT);
    }

    public void storeDescent(int fontSizeIndex, int condenseIndex, int descent) {
        this.store(fontSizeIndex, condenseIndex, descent, FontAttribute.DESCENT);
    }

    public void storeHeight(int fontSizeIndex, int condenseIndex, int height) {
        this.store(fontSizeIndex, condenseIndex, height, FontAttribute.HEIGHT);
    }

    public void storeWidth(int fontSizeIndex, int condenseIndex, int width) {
        this.store(fontSizeIndex, condenseIndex, width, FontAttribute.WIDTH);
    }

    private void store(int fontSizeIndex, int condenseIndex, int value, FontAttribute attribute) {
        this.attributeMap.get((Object)attribute).put(this.getIndex(fontSizeIndex, condenseIndex), value);
    }

    private String getIndex(int fontSizeIndex, int condenseIndex) {
        return String.valueOf(fontSizeIndex) + String.valueOf(condenseIndex);
    }

    public int getAscent(int fontSizeIndex, int condenseIndex) {
        return this.getValue(fontSizeIndex, condenseIndex, FontAttribute.ASCENT);
    }

    public int getDescent(int fontSizeIndex, int condenseIndex) {
        return this.getValue(fontSizeIndex, condenseIndex, FontAttribute.DESCENT);
    }

    public int getHeight(int fontSizeIndex, int condenseIndex) {
        return this.getValue(fontSizeIndex, condenseIndex, FontAttribute.HEIGHT);
    }

    public int getWidth(int fontSizeIndex, int condenseIndex) {
        return this.getValue(fontSizeIndex, condenseIndex, FontAttribute.WIDTH);
    }

    private int getValue(int fontSizeIndex, int condenseIndex, FontAttribute attribute) {
        return this.attributeMap.get((Object)attribute).get(this.getIndex(fontSizeIndex, condenseIndex));
    }

    public boolean containsAscent(int fontSizeIndex, int condenseIndex) {
        return this.contains(fontSizeIndex, condenseIndex, FontAttribute.ASCENT);
    }

    public boolean containsDescent(int fontSizeIndex, int condenseIndex) {
        return this.contains(fontSizeIndex, condenseIndex, FontAttribute.DESCENT);
    }

    public boolean containsHeight(int fontSizeIndex, int condenseIndex) {
        return this.contains(fontSizeIndex, condenseIndex, FontAttribute.HEIGHT);
    }

    public boolean containsWidth(int fontSizeIndex, int condenseIndex) {
        return this.contains(fontSizeIndex, condenseIndex, FontAttribute.WIDTH);
    }

    private boolean contains(int fontSizeIndex, int condenseIndex, FontAttribute attribute) {
        return this.attributeMap.get((Object)attribute).containsKey(this.getIndex(fontSizeIndex, condenseIndex));
    }

    public static enum FontAttribute {
        ASCENT,
        DESCENT,
        HEIGHT,
        WIDTH;

    }
}

