/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.text.JavaFontLoader;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class ESLFontLoader {
    static ESLLogger logger = ESLLogger.getLogger(ESLFontLoader.class);
    private static final File DEFAULT_FONT_DIRECTORY = new File("data/fonts");
    private File fontDirectory;

    public ESLFontLoader() {
        this(DEFAULT_FONT_DIRECTORY);
    }

    public ESLFontLoader(File fontDirectory) {
        this.fontDirectory = fontDirectory;
        this.registerFonts(fontDirectory);
    }

    private void registerFonts(File fontDirectory) {
        if (fontDirectory.exists()) {
            JavaFontLoader fontLoader = new JavaFontLoader();
            Collection fontFiles = FileUtils.listFiles((File)fontDirectory, (String[])new String[]{"ttf"}, (boolean)true);
            fontFiles.addAll(FileUtils.listFiles((File)fontDirectory, (String[])new String[]{"otf"}, (boolean)true));
            int successfulRegistrations = 0;
            for (File fontFile : fontFiles) {
                try {
                    Font font = fontLoader.createFont(fontFile);
                    if (this.fontAlreadyInstalled(font)) {
                        logger.info("Font %s already installed on the system", font.getName());
                        continue;
                    }
                    if (!fontLoader.registerFont(font)) {
                        logger.warn("Unable to install font from file %s", fontFile.getName());
                        continue;
                    }
                    ++successfulRegistrations;
                    logger.info("Font %s installed", fontFile.getName());
                }
                catch (Exception exc) {
                    logger.warn("Could not load font from file %s: %s", fontFile.getName(), exc.getMessage());
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
            if (fontFiles.size() > 0) {
                logger.info("%d of %d fonts successfully installed", successfulRegistrations, fontFiles.size());
            }
        } else {
            logger.debug("Fonts directory (%s) does not exist", fontDirectory.getPath());
        }
    }

    private boolean fontAlreadyInstalled(Font font) {
        Font[] availableFonts;
        for (Font availableFont : availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!availableFont.getName().equals(font.getName())) continue;
            return true;
        }
        return false;
    }

    public File getFontDirectory() {
        return this.fontDirectory;
    }
}

