/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.DrawLineStrategy;
import at.mrdevelopment.toolkit.text.Span;
import at.mrdevelopment.toolkit.text.TextLine;
import at.mrdevelopment.toolkit.text.TextUtils;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class CenterStrategy
extends DrawLineStrategy {
    @Override
    public Rectangle draw(TextLine textLine, Graphics2D graphics, int xPos, int yPos, int width) throws OptionException {
        return this.layout(textLine, graphics, xPos, yPos, width, true);
    }

    @Override
    public Rectangle getBounds(TextLine textLine, Graphics2D graphics, int xPos, int yPos, int width) throws OptionException {
        return this.layout(textLine, graphics, xPos, yPos, width, false);
    }

    private Rectangle layout(TextLine textLine, Graphics2D graphics, int xPos, int yPos, int maxWidth, boolean draw) throws OptionException {
        xPos = this.getXStartPosition(textLine, graphics, xPos, maxWidth);
        int largestAscent = textLine.getLargestAscent(graphics);
        Rectangle bounds = new Rectangle(new Point(xPos, yPos));
        for (int i = 0; i < textLine.getAllWords().size(); ++i) {
            Rectangle currentBounds;
            Word word = textLine.getAllWords().get(i);
            int width = word.getWidth(graphics);
            if (i == textLine.getAllWords().size() - 1 && word.getText().endsWith(" ")) {
                width -= word.getDelimiterWidth(graphics);
            }
            int xAfterWord = width;
            int heightOffset = largestAscent - word.getAscent(graphics);
            if (draw) {
                this.applyCompoundStyle(word, textLine, graphics, xPos, yPos, maxWidth);
                currentBounds = word.draw(graphics, xPos, yPos + heightOffset);
                if (i == textLine.getAllWords().size() - 1 && word.getText().endsWith(" ")) {
                    currentBounds.width -= word.getDelimiterWidth(graphics);
                }
                bounds.add(currentBounds);
            } else {
                currentBounds = word.getBounds(graphics, xPos, yPos + heightOffset);
                if (i == textLine.getAllWords().size() - 1 && word.getText().endsWith(" ")) {
                    currentBounds.width -= word.getDelimiterWidth(graphics);
                }
                bounds.add(currentBounds);
            }
            xPos += xAfterWord;
        }
        return bounds;
    }

    private int getXStartPosition(TextLine textLine, Graphics2D graphics, int xPos, int maxWidth) throws IndexOutOfBoundsException, OptionException {
        int contentWidth = TextUtils.getContentWidth(textLine.getAllWords(), graphics);
        Word lastWord = textLine.getAllWords().get(textLine.getAllWords().size() - 1);
        if (lastWord.getText().endsWith(" ")) {
            contentWidth -= lastWord.getDelimiterWidth(graphics);
        }
        int xPosStart = contentWidth > maxWidth ? 0 : (maxWidth - contentWidth) / 2 + xPos;
        return xPosStart > 0 ? xPosStart : 0;
    }

    @Override
    protected Rectangle getSpanBoundsInLine(TextLine textLine, Span span, Word word, Graphics2D graphics, int xPos, int yPos, int maxWidth) throws OptionException {
        Rectangle bounds = null;
        List<Word> wordsInSpan = span.getLeaves();
        int largestAscent = textLine.getLargestAscent(graphics);
        for (Word spanWord : wordsInSpan) {
            if (!textLine.getAllWords().contains(spanWord)) continue;
            int xAfterWord = spanWord.getWidth(graphics);
            int heightOffset = largestAscent - spanWord.getAscent(graphics);
            if (bounds == null) {
                bounds = spanWord.getBounds(graphics, xPos, yPos + heightOffset);
            } else {
                bounds.add(spanWord.getBounds(graphics, xPos, yPos + heightOffset));
            }
            xPos += xAfterWord;
        }
        return bounds;
    }
}

