/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.string;

import at.mrdevelopment.toolkit.text.LineWrap;
import java.util.ArrayList;
import java.util.List;

public class CustomStringTokenizer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private Last last = Last.NONE;

    public List<String> tokenize(String text, LineWrap lineWrap) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (this.isWrapDelimiter(c, lineWrap)) {
                if (this.last != Last.WHITESPACE) {
                    stringBuilder.append(c);
                    tokens.add(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                }
                this.last = this.last == Last.WHITESPACE ? Last.WHITESPACE : Last.NONE;
                continue;
            }
            if (c == NEWLINE.charAt(0) || NEWLINE.toCharArray().length > 1 && c == NEWLINE.charAt(1)) continue;
            if (this.last != Last.CHAR && this.last != Last.NONE) {
                tokens.add(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.length());
            }
            stringBuilder.append(c);
            this.last = Last.CHAR;
        }
        tokens.add(stringBuilder.toString());
        return tokens;
    }

    public void reset() {
        this.last = Last.NONE;
    }

    public boolean isNewlineToken(String token) {
        return NEWLINE.equals(token);
    }

    private boolean isWrapDelimiter(char c, LineWrap lineWrap) {
        for (char delimiter : lineWrap.getDelimiters()) {
            if (c != delimiter) continue;
            return true;
        }
        return false;
    }

    private static enum Last {
        NONE,
        WHITESPACE,
        CHAR;

    }
}

