/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.exec.InterruptTimerTask;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class LinuxVersionLoader {
    static ESLLogger logger = ESLLogger.getLogger(LinuxVersionLoader.class);
    private static String KERNEL_VERSION_COMMAND = "uname -r";
    private static String KERNEL_CMD_LINE = "/proc/cmdline";
    private static String UBOOT_VERSION_VARIABLE = "ver";
    private static String BOOT_SCRIPT_VARIABLE = "boot_script_version";
    private static final long DEFAULT_PROCESS_TIMEOUT = 20000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version loadKernelVersion() {
        Process process = null;
        Timer timeoutTimer = null;
        try {
            timeoutTimer = new Timer(true);
            InterruptTimerTask interrupter = new InterruptTimerTask(Thread.currentThread(), logger);
            timeoutTimer.schedule((TimerTask)interrupter, 20000L);
            process = Runtime.getRuntime().exec(KERNEL_VERSION_COMMAND);
            int exitCode = process.waitFor();
            logger.info("Command finished with return value %d", exitCode);
            List lines = IOUtils.readLines((InputStream)process.getInputStream());
            if (lines.size() > 0) {
                String versionString = (String)lines.get(0);
                String[] splitted = StringUtils.split((String)versionString, (String)"-");
                Version kernelVersion = Version.fromString(splitted[0]);
                logger.debug("Received kernel version string '%s'", versionString);
                if (splitted.length > 1) {
                    try {
                        kernelVersion = new Version(kernelVersion, Integer.valueOf(splitted[1]));
                    }
                    catch (NumberFormatException exc) {
                        logger.warn("Invalid build number in kernel version: '%s'", versionString);
                        logger.logExceptionIfDebugEnabled(exc);
                    }
                }
                logger.info("Loaded kernel version %s", kernelVersion.getVersionString());
                Version version = kernelVersion;
                return version;
            }
            logger.info("Could not obtain kernel version");
        }
        catch (InterruptedException exc) {
            if (process != null) {
                process.destroy();
            }
        }
        catch (Exception exc) {
            logger.info("Failed to read kernel version: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        finally {
            if (timeoutTimer != null) {
                timeoutTimer.cancel();
            }
            Thread.interrupted();
        }
        return Version.UNDEFINED;
    }

    private static String loadVersionFromKernelCommandLine(String variableName, boolean useCurrentIndex) {
        try {
            List commandLines = FileUtils.readLines((File)new File(KERNEL_CMD_LINE));
            if (commandLines.size() > 0) {
                logger.debug("Received kernel cmdline '%s'", commandLines.get(0));
                String[] splitted = StringUtils.split((String)((String)commandLines.get(0)), (String)" ");
                for (int index = 0; index < splitted.length; ++index) {
                    if (!splitted[index].startsWith(variableName)) continue;
                    if (useCurrentIndex) {
                        return splitted[index].replace(variableName + "=", "");
                    }
                    return index + 1 < splitted.length ? splitted[index + 1] : null;
                }
            }
        }
        catch (IOException exc) {
            logger.info("Unable to kernel command line version");
            logger.logExceptionIfDebugEnabled(exc);
        }
        return null;
    }

    private static Version parseVersionFromString(String versionString) {
        if (versionString != null) {
            String[] splittedVersionAndBuildString = versionString.split("-");
            String[] splittedVersion = StringUtils.split((String)splittedVersionAndBuildString[0], (String)".");
            String versionOnylString = splittedVersionAndBuildString[0];
            if (splittedVersion[0].length() == 4) {
                versionOnylString = versionOnylString.replaceFirst(splittedVersion[0], splittedVersion[0].substring(2));
            }
            Version version = Version.fromString(versionOnylString);
            if (splittedVersionAndBuildString.length > 1 && !splittedVersionAndBuildString[1].equals("dirty")) {
                try {
                    version = new Version(version, Integer.valueOf(splittedVersionAndBuildString[1]));
                }
                catch (NumberFormatException exc) {
                    logger.info("Invalid build number version: '%s'", versionString);
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
            logger.info("Loaded version %s", version.getVersionString());
            return version;
        }
        return Version.UNDEFINED;
    }

    public static Version loadUBootVersion() {
        String versionString = LinuxVersionLoader.loadVersionFromKernelCommandLine(UBOOT_VERSION_VARIABLE, false);
        if (versionString == null) {
            logger.info("No u-boot version detected");
            return Version.UNDEFINED;
        }
        return LinuxVersionLoader.parseVersionFromString(versionString);
    }

    public static Version loadBootScriptVersion() {
        String versionString = LinuxVersionLoader.loadVersionFromKernelCommandLine(BOOT_SCRIPT_VARIABLE, true);
        if (versionString == null) {
            logger.info("No boot script version detected");
            return Version.UNDEFINED;
        }
        return LinuxVersionLoader.parseVersionFromString(versionString);
    }
}

