/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.optionvalue;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import at.mrdevelopment.toolkit.options.optionvalue.ElementAttributeOptionValue;
import at.mrdevelopment.toolkit.options.optionvalue.FieldOptionValue;
import at.mrdevelopment.toolkit.options.optionvalue.OptionValue;
import at.mrdevelopment.toolkit.options.optionvalue.OptionValueFactory;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;

public class OptionValueFactoryImpl<T>
implements OptionValueFactory<T> {
    private Converter<T, String> stringConverter;

    public OptionValueFactoryImpl(Converter<T, String> stringConverter) {
        this.stringConverter = stringConverter;
    }

    @Override
    public OptionValue<T> getOptionValue(OptionValueFactory.OptionValueType type, Object ... args) throws OptionException {
        switch (type) {
            case ELEMENT_ATTRIBUTE: {
                if (!(args.length == 3 && args[0] instanceof Element && args[1] instanceof String && args[2] instanceof String)) {
                    throw new OptionException(this.getExceptionMessage(ElementAttributeOptionValue.class));
                }
                return new ElementAttributeOptionValue<T>((Element)args[0], (String)args[1], (String)args[2], this.stringConverter);
            }
            case FIELD: {
                return new FieldOptionValue();
            }
            case TEXT: {
                return null;
            }
        }
        throw new OptionException("Unavailable OptionValueType " + (Object)((Object)type));
    }

    private String getExceptionMessage(Class<?> classInCreation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error instantiating " + classInCreation.getSimpleName() + ".\n" + "Please pass object to conform to one of the following constructors (omitting the stringConverter argument):\n");
        for (Constructor<?> constructor : classInCreation.getConstructors()) {
            builder.append(constructor.toString() + "\n");
        }
        return builder.toString();
    }
}

